/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.yaml.swapper.impl;

import org.apache.shardingsphere.api.config.shadow.ShadowRuleConfiguration;
import org.apache.shardingsphere.core.yaml.config.shadow.YamlShadowRuleConfiguration;
import org.apache.shardingsphere.core.yaml.swapper.MasterSlaveRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.core.yaml.swapper.ShardingRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.encrypt.yaml.swapper.EncryptRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.underlying.common.yaml.swapper.YamlSwapper;

public final class ShadowRuleConfigurationYamlSwapper
implements YamlSwapper<YamlShadowRuleConfiguration, ShadowRuleConfiguration> {
    private final ShardingRuleConfigurationYamlSwapper shardingRuleConfigurationYamlSwapper = new ShardingRuleConfigurationYamlSwapper();
    private final EncryptRuleConfigurationYamlSwapper encryptRuleConfigurationYamlSwapper = new EncryptRuleConfigurationYamlSwapper();
    private final MasterSlaveRuleConfigurationYamlSwapper masterSlaveRuleConfigurationYamlSwapper = new MasterSlaveRuleConfigurationYamlSwapper();

    public YamlShadowRuleConfiguration swap(ShadowRuleConfiguration data) {
        YamlShadowRuleConfiguration result = new YamlShadowRuleConfiguration();
        result.setColumn(data.getColumn());
        result.setShadowMappings(data.getShadowMappings());
        if (data.isEncrypt()) {
            result.setEncryptRule(this.encryptRuleConfigurationYamlSwapper.swap(data.getEncryptRuleConfig()));
        } else if (data.isMasterSlave()) {
            result.setMasterSlaveRule(this.masterSlaveRuleConfigurationYamlSwapper.swap(data.getMasterSlaveRuleConfig()));
        } else if (data.isSharding()) {
            result.setShardingRule(this.shardingRuleConfigurationYamlSwapper.swap(data.getShardingRuleConfig()));
        }
        return result;
    }

    public ShadowRuleConfiguration swap(YamlShadowRuleConfiguration yamlConfiguration) {
        ShadowRuleConfiguration result = new ShadowRuleConfiguration();
        result.setColumn(yamlConfiguration.getColumn());
        result.setShadowMappings(yamlConfiguration.getShadowMappings());
        if (yamlConfiguration.isEncrypt()) {
            result.setEncryptRuleConfig(this.encryptRuleConfigurationYamlSwapper.swap(yamlConfiguration.getEncryptRule()));
        } else if (yamlConfiguration.isMasterSlave()) {
            result.setMasterSlaveRuleConfig(this.masterSlaveRuleConfigurationYamlSwapper.swap(yamlConfiguration.getMasterSlaveRule()));
        } else if (yamlConfiguration.isSharding()) {
            result.setShardingRuleConfig(this.shardingRuleConfigurationYamlSwapper.swap(yamlConfiguration.getShardingRule()));
        }
        return result;
    }
}

