/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.DistributedManager;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class PersistentManagerBase
extends ManagerBase
implements DistributedManager {
    private static final Log log = LogFactory.getLog(PersistentManagerBase.class);
    private static final String info = "PersistentManagerBase/1.1";
    private static String name = "PersistentManagerBase";
    protected Store store = null;
    protected boolean saveOnRestart = true;
    protected int maxIdleBackup = -1;
    protected int minIdleSwap = -1;
    protected int maxIdleSwap = -1;
    private final Map<String, Object> sessionSwapInLocks = new HashMap<String, Object>();

    public int getMaxIdleBackup() {
        return this.maxIdleBackup;
    }

    public void setMaxIdleBackup(int backup) {
        if (backup == this.maxIdleBackup) {
            return;
        }
        int oldBackup = this.maxIdleBackup;
        this.maxIdleBackup = backup;
        this.support.firePropertyChange("maxIdleBackup", (Object)oldBackup, (Object)this.maxIdleBackup);
    }

    public int getMaxIdleSwap() {
        return this.maxIdleSwap;
    }

    public void setMaxIdleSwap(int max) {
        if (max == this.maxIdleSwap) {
            return;
        }
        int oldMaxIdleSwap = this.maxIdleSwap;
        this.maxIdleSwap = max;
        this.support.firePropertyChange("maxIdleSwap", (Object)oldMaxIdleSwap, (Object)this.maxIdleSwap);
    }

    public int getMinIdleSwap() {
        return this.minIdleSwap;
    }

    public void setMinIdleSwap(int min) {
        if (this.minIdleSwap == min) {
            return;
        }
        int oldMinIdleSwap = this.minIdleSwap;
        this.minIdleSwap = min;
        this.support.firePropertyChange("minIdleSwap", (Object)oldMinIdleSwap, (Object)this.minIdleSwap);
    }

    @Override
    public String getInfo() {
        return info;
    }

    public boolean isLoaded(String id) {
        try {
            if (super.findSession(id) != null) {
                return true;
            }
        }
        catch (IOException e) {
            log.error((Object)("checking isLoaded for id, " + id + ", " + e.getMessage()), (Throwable)e);
        }
        return false;
    }

    @Override
    public String getName() {
        return name;
    }

    public void setStore(Store store) {
        this.store = store;
        store.setManager(this);
    }

    public Store getStore() {
        return this.store;
    }

    public boolean getSaveOnRestart() {
        return this.saveOnRestart;
    }

    public void setSaveOnRestart(boolean saveOnRestart) {
        if (saveOnRestart == this.saveOnRestart) {
            return;
        }
        boolean oldSaveOnRestart = this.saveOnRestart;
        this.saveOnRestart = saveOnRestart;
        this.support.firePropertyChange("saveOnRestart", (Object)oldSaveOnRestart, (Object)this.saveOnRestart);
    }

    public void clearStore() {
        if (this.store == null) {
            return;
        }
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreClear());
                }
                catch (PrivilegedActionException ex) {
                    Exception exception = ex.getException();
                    log.error((Object)("Exception clearing the Store: " + exception), (Throwable)exception);
                }
            } else {
                this.store.clear();
            }
        }
        catch (IOException e) {
            log.error((Object)("Exception clearing the Store: " + e), (Throwable)e);
        }
    }

    @Override
    public void processExpires() {
        long timeNow = System.currentTimeMillis();
        Session[] sessions = this.findSessions();
        int expireHere = 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start expire sessions " + this.getName() + " at " + timeNow + " sessioncount " + sessions.length));
        }
        for (int i = 0; i < sessions.length; ++i) {
            if (sessions[i].isValid()) continue;
            this.expiredSessions.incrementAndGet();
            ++expireHere;
        }
        this.processPersistenceChecks();
        if (this.getStore() != null && this.getStore() instanceof StoreBase) {
            ((StoreBase)this.getStore()).processExpires();
        }
        long timeEnd = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("End expire sessions " + this.getName() + " processingTime " + (timeEnd - timeNow) + " expired sessions: " + expireHere));
        }
        this.processingTime += timeEnd - timeNow;
    }

    public void processPersistenceChecks() {
        this.processMaxIdleSwaps();
        this.processMaxActiveSwaps();
        this.processMaxIdleBackups();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session findSession(String id) throws IOException {
        Session session = super.findSession(id);
        if (session != null) {
            Session session2 = session;
            synchronized (session2) {
                session = super.findSession(session.getIdInternal());
                if (session != null) {
                    session.access();
                    session.endAccess();
                }
            }
        }
        if (session != null) {
            return session;
        }
        session = this.swapIn(id);
        return session;
    }

    public void removeSuper(Session session) {
        super.remove(session);
    }

    @Override
    public void load() {
        String[] ids;
        block11: {
            this.sessions.clear();
            if (this.store == null) {
                return;
            }
            ids = null;
            try {
                if (SecurityUtil.isPackageProtectionEnabled()) {
                    try {
                        ids = AccessController.doPrivileged(new PrivilegedStoreKeys());
                        break block11;
                    }
                    catch (PrivilegedActionException ex) {
                        Exception exception = ex.getException();
                        log.error((Object)("Exception in the Store during load: " + exception), (Throwable)exception);
                        return;
                    }
                }
                ids = this.store.keys();
            }
            catch (IOException e) {
                log.error((Object)("Can't load sessions from store, " + e.getMessage()), (Throwable)e);
                return;
            }
        }
        int n = ids.length;
        if (n == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("persistentManager.loading", String.valueOf(n)));
        }
        for (int i = 0; i < n; ++i) {
            try {
                this.swapIn(ids[i]);
                continue;
            }
            catch (IOException e) {
                log.error((Object)("Failed load session from store, " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public void remove(Session session, boolean update) {
        super.remove(session, update);
        if (this.store != null) {
            this.removeSession(session.getIdInternal());
        }
    }

    protected void removeSession(String id) {
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreRemove(id));
                }
                catch (PrivilegedActionException ex) {
                    Exception exception = ex.getException();
                    log.error((Object)("Exception in the Store during removeSession: " + exception), (Throwable)exception);
                }
            } else {
                this.store.remove(id);
            }
        }
        catch (IOException e) {
            log.error((Object)("Exception removing session  " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void unload() {
        if (this.store == null) {
            return;
        }
        Session[] sessions = this.findSessions();
        int n = sessions.length;
        if (n == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("persistentManager.unloading", String.valueOf(n)));
        }
        for (int i = 0; i < n; ++i) {
            try {
                this.swapOut(sessions[i]);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    @Override
    public int getActiveSessionsFull() {
        int result = this.getActiveSessions();
        try {
            result += this.getStore().getSize();
        }
        catch (IOException ioe) {
            log.warn((Object)sm.getString("persistentManager.storeSizeException"));
        }
        return result;
    }

    @Override
    public Set<String> getSessionIdsFull() {
        HashSet<String> sessionIds = new HashSet<String>();
        sessionIds.addAll(this.sessions.keySet());
        try {
            String[] storeKeys;
            for (String storeKey : storeKeys = this.getStore().keys()) {
                sessionIds.add(storeKey);
            }
        }
        catch (IOException e) {
            log.warn((Object)sm.getString("persistentManager.storeKeysException"));
        }
        return sessionIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session swapIn(String id) throws IOException {
        if (this.store == null) {
            return null;
        }
        Object swapInLock = null;
        PersistentManagerBase persistentManagerBase = this;
        synchronized (persistentManagerBase) {
            swapInLock = this.sessionSwapInLocks.get(id);
            if (swapInLock == null) {
                swapInLock = new Object();
                this.sessionSwapInLocks.put(id, swapInLock);
            }
        }
        Session session = null;
        Object object = swapInLock;
        synchronized (object) {
            session = (Session)this.sessions.get(id);
            if (session == null) {
                block22: {
                    try {
                        if (SecurityUtil.isPackageProtectionEnabled()) {
                            try {
                                session = AccessController.doPrivileged(new PrivilegedStoreLoad(id));
                                break block22;
                            }
                            catch (PrivilegedActionException ex) {
                                Exception e = ex.getException();
                                log.error((Object)sm.getString("persistentManager.swapInException", id), (Throwable)e);
                                if (e instanceof IOException) {
                                    throw (IOException)e;
                                }
                                if (e instanceof ClassNotFoundException) {
                                    throw (ClassNotFoundException)e;
                                }
                                break block22;
                            }
                        }
                        session = this.store.load(id);
                    }
                    catch (ClassNotFoundException e) {
                        String msg = sm.getString("persistentManager.deserializeError", id);
                        log.error((Object)msg, (Throwable)e);
                        throw new IllegalStateException(msg, e);
                    }
                }
                if (session != null && !session.isValid()) {
                    log.error((Object)sm.getString("persistentManager.swapInInvalid", id));
                    session.expire();
                    this.removeSession(id);
                    session = null;
                }
                if (session != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("persistentManager.swapIn", id));
                    }
                    session.setManager(this);
                    ((StandardSession)session).tellNew();
                    this.add(session);
                    ((StandardSession)session).activate();
                    session.access();
                    session.endAccess();
                }
            }
        }
        object = this;
        synchronized (object) {
            this.sessionSwapInLocks.remove(id);
        }
        return session;
    }

    protected void swapOut(Session session) throws IOException {
        if (this.store == null || !session.isValid()) {
            return;
        }
        ((StandardSession)session).passivate();
        this.writeSession(session);
        super.remove(session, true);
        session.recycle();
    }

    protected void writeSession(Session session) throws IOException {
        if (this.store == null || !session.isValid()) {
            return;
        }
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreSave(session));
                }
                catch (PrivilegedActionException ex) {
                    Exception exception = ex.getException();
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    log.error((Object)("Exception in the Store during writeSession: " + exception), (Throwable)exception);
                }
            } else {
                this.store.save(session);
            }
        }
        catch (IOException e) {
            log.error((Object)sm.getString("persistentManager.serializeError", session.getIdInternal(), e));
            throw e;
        }
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        super.startInternal();
        if (this.store == null) {
            log.error((Object)"No Store configured, persistence disabled");
        } else if (this.store instanceof Lifecycle) {
            ((Lifecycle)((Object)this.store)).start();
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping");
        }
        this.setState(LifecycleState.STOPPING);
        if (this.getStore() != null && this.saveOnRestart) {
            this.unload();
        } else {
            Session[] sessions = this.findSessions();
            for (int i = 0; i < sessions.length; ++i) {
                StandardSession session = (StandardSession)sessions[i];
                if (!session.isValid()) continue;
                session.expire();
            }
        }
        if (this.getStore() != null && this.getStore() instanceof Lifecycle) {
            ((Lifecycle)((Object)this.getStore())).stop();
        }
        super.stopInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMaxIdleSwaps() {
        if (!this.getState().isAvailable() || this.maxIdleSwap < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        long timeNow = System.currentTimeMillis();
        if (this.maxIdleSwap >= 0) {
            for (int i = 0; i < sessions.length; ++i) {
                StandardSession session;
                StandardSession standardSession = session = (StandardSession)sessions[i];
                synchronized (standardSession) {
                    if (!session.isValid()) {
                        continue;
                    }
                    int timeIdle = StandardSession.LAST_ACCESS_AT_START ? (int)((timeNow - session.getLastAccessedTime()) / 1000L) : (int)((timeNow - session.getThisAccessedTime()) / 1000L);
                    if (timeIdle > this.maxIdleSwap && timeIdle > this.minIdleSwap) {
                        if (session.accessCount != null && session.accessCount.get() > 0) {
                            continue;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("persistentManager.swapMaxIdle", session.getIdInternal(), timeIdle));
                        }
                        try {
                            this.swapOut(session);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMaxActiveSwaps() {
        if (!this.getState().isAvailable() || this.getMaxActiveSessions() < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        if (this.getMaxActiveSessions() >= sessions.length) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("persistentManager.tooManyActive", sessions.length));
        }
        int toswap = sessions.length - this.getMaxActiveSessions();
        long timeNow = System.currentTimeMillis();
        for (int i = 0; i < sessions.length && toswap > 0; ++i) {
            StandardSession session;
            StandardSession standardSession = session = (StandardSession)sessions[i];
            synchronized (standardSession) {
                int timeIdle = StandardSession.LAST_ACCESS_AT_START ? (int)((timeNow - session.getLastAccessedTime()) / 1000L) : (int)((timeNow - session.getThisAccessedTime()) / 1000L);
                if (timeIdle > this.minIdleSwap) {
                    if (session.accessCount != null && session.accessCount.get() > 0) {
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("persistentManager.swapTooManyActive", session.getIdInternal(), timeIdle));
                    }
                    try {
                        this.swapOut(session);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    --toswap;
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMaxIdleBackups() {
        if (!this.getState().isAvailable() || this.maxIdleBackup < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        long timeNow = System.currentTimeMillis();
        if (this.maxIdleBackup >= 0) {
            for (int i = 0; i < sessions.length; ++i) {
                StandardSession session;
                StandardSession standardSession = session = (StandardSession)sessions[i];
                synchronized (standardSession) {
                    if (!session.isValid()) {
                        continue;
                    }
                    int timeIdle = StandardSession.LAST_ACCESS_AT_START ? (int)((timeNow - session.getLastAccessedTime()) / 1000L) : (int)((timeNow - session.getThisAccessedTime()) / 1000L);
                    if (timeIdle > this.maxIdleBackup) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("persistentManager.backupMaxIdle", session.getIdInternal(), timeIdle));
                        }
                        try {
                            this.writeSession(session);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    continue;
                }
            }
        }
    }

    private class PrivilegedStoreKeys
    implements PrivilegedExceptionAction<String[]> {
        PrivilegedStoreKeys() {
        }

        @Override
        public String[] run() throws Exception {
            return PersistentManagerBase.this.store.keys();
        }
    }

    private class PrivilegedStoreSave
    implements PrivilegedExceptionAction<Void> {
        private Session session;

        PrivilegedStoreSave(Session session) {
            this.session = session;
        }

        @Override
        public Void run() throws Exception {
            PersistentManagerBase.this.store.save(this.session);
            return null;
        }
    }

    private class PrivilegedStoreLoad
    implements PrivilegedExceptionAction<Session> {
        private String id;

        PrivilegedStoreLoad(String id) {
            this.id = id;
        }

        @Override
        public Session run() throws Exception {
            return PersistentManagerBase.this.store.load(this.id);
        }
    }

    private class PrivilegedStoreRemove
    implements PrivilegedExceptionAction<Void> {
        private String id;

        PrivilegedStoreRemove(String id) {
            this.id = id;
        }

        @Override
        public Void run() throws Exception {
            PersistentManagerBase.this.store.remove(this.id);
            return null;
        }
    }

    private class PrivilegedStoreClear
    implements PrivilegedExceptionAction<Void> {
        PrivilegedStoreClear() {
        }

        @Override
        public Void run() throws Exception {
            PersistentManagerBase.this.store.clear();
            return null;
        }
    }
}

