/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.scan;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarEntry;
import org.apache.tomcat.util.scan.Jar;
import org.apache.tomcat.util.scan.NonClosingJarInputStream;

public class UrlJar
implements Jar {
    private NonClosingJarInputStream jarInputStream = null;
    private URL url = null;
    private JarEntry entry = null;

    public UrlJar(URL url) throws IOException {
        this.url = url;
        this.jarInputStream = this.createJarInputStream();
    }

    @Override
    public boolean entryExists(String name) throws IOException {
        JarEntry entry = this.jarInputStream.getNextJarEntry();
        while (entry != null && !name.equals(entry.getName())) {
            entry = this.jarInputStream.getNextJarEntry();
        }
        return entry != null;
    }

    @Override
    public InputStream getInputStream(String name) throws IOException {
        JarEntry entry = this.jarInputStream.getNextJarEntry();
        while (entry != null && !name.equals(entry.getName())) {
            entry = this.jarInputStream.getNextJarEntry();
        }
        if (entry == null) {
            return null;
        }
        return this.jarInputStream;
    }

    @Override
    public void close() {
        if (this.jarInputStream != null) {
            try {
                this.jarInputStream.reallyClose();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private NonClosingJarInputStream createJarInputStream() throws IOException {
        JarURLConnection jarConn = (JarURLConnection)this.url.openConnection();
        URL resourceURL = jarConn.getJarFileURL();
        URLConnection resourceConn = resourceURL.openConnection();
        resourceConn.setUseCaches(false);
        return new NonClosingJarInputStream(resourceConn.getInputStream());
    }

    @Override
    public void nextEntry() {
        try {
            this.entry = this.jarInputStream.getNextJarEntry();
        }
        catch (IOException ioe) {
            this.entry = null;
        }
    }

    @Override
    public String getEntryName() {
        if (this.entry == null) {
            return null;
        }
        return this.entry.getName();
    }

    @Override
    public InputStream getEntryInputStream() throws IOException {
        return this.jarInputStream;
    }

    @Override
    public void reset() throws IOException {
        this.close();
        this.jarInputStream = this.createJarInputStream();
    }
}

