/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import org.apache.catalina.mapper.MappingData;
import org.apache.catalina.servlet4preview.http.Mapping;
import org.apache.catalina.servlet4preview.http.MappingMatch;

public class ApplicationMapping {
    private final MappingData mappingData;
    private volatile Mapping mapping = null;

    public ApplicationMapping(MappingData mappingData) {
        this.mappingData = mappingData;
    }

    public Mapping getMapping() {
        if (this.mapping == null) {
            if (this.mappingData == null) {
                this.mapping = new MappingImpl("", "", MappingMatch.UNKNOWN, "");
            } else {
                String servletName = this.mappingData.wrapper == null ? "" : this.mappingData.wrapper.getName();
                switch (this.mappingData.matchType) {
                    case CONTEXT_ROOT: {
                        this.mapping = new MappingImpl("", "", this.mappingData.matchType, servletName);
                        break;
                    }
                    case DEFAULT: {
                        this.mapping = new MappingImpl("/", "/", this.mappingData.matchType, servletName);
                        break;
                    }
                    case EXACT: {
                        this.mapping = new MappingImpl(this.mappingData.wrapperPath.toString(), this.mappingData.wrapperPath.toString(), this.mappingData.matchType, servletName);
                        break;
                    }
                    case EXTENSION: {
                        String path = this.mappingData.wrapperPath.toString();
                        int extIndex = path.lastIndexOf(46);
                        this.mapping = new MappingImpl(path.substring(0, extIndex), "*" + path.substring(extIndex), this.mappingData.matchType, servletName);
                        break;
                    }
                    case PATH: {
                        this.mapping = new MappingImpl(this.mappingData.pathInfo.toString(), this.mappingData.wrapperPath.toString() + "/*", this.mappingData.matchType, servletName);
                        break;
                    }
                    case UNKNOWN: {
                        this.mapping = new MappingImpl("", "", this.mappingData.matchType, servletName);
                    }
                }
            }
        }
        return this.mapping;
    }

    public void recycle() {
        this.mapping = null;
    }

    private static class MappingImpl
    implements Mapping {
        private final String matchValue;
        private final String pattern;
        private final MappingMatch mappingType;
        private final String servletName;

        public MappingImpl(String matchValue, String pattern, MappingMatch mappingType, String servletName) {
            this.matchValue = matchValue;
            this.pattern = pattern;
            this.mappingType = mappingType;
            this.servletName = servletName;
        }

        @Override
        public String getMatchValue() {
            return this.matchValue;
        }

        @Override
        public String getPattern() {
            return this.pattern;
        }

        @Override
        public MappingMatch getMappingMatch() {
            return this.mappingType;
        }

        @Override
        public String getServletName() {
            return this.servletName;
        }
    }
}

