/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.wicket.util.template;

import java.util.Map;

import org.apache.wicket.markup.html.link.ResourceLink;


/**
 * Links to shared, interpolated <code>TextTemplate</code> resources created by a factory. This is
 * useful for creating dynamic JNLP descriptors, among other things.
 * 
 * @author Jonathan Locke
 * @since 1.2.6
 */
public class TextTemplateLink extends ResourceLink
{
	private static final long serialVersionUID = 1L;

	/**
	 * Constructor.
	 * 
	 * @param id
	 *            the <code>Component</code> id
	 * @param factory
	 *            the factory to create resources with
	 * @param variables
	 *            variables to interpolate into the template held by the shared resource factory
	 */
	public TextTemplateLink(final String id, final TextTemplateSharedResourceFactory factory,
			final Map variables)
	{
		super(id, factory.resourceReference(variables));
	}
}
