/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.util.Map;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.util.string.IStringIterator;
import org.apache.wicket.util.string.StringList;
import org.apache.wicket.util.value.ValueMap;

public final class PageParameters
extends ValueMap {
    public static final PageParameters NULL = new PageParameters();
    private static final long serialVersionUID = 1L;

    public PageParameters() {
        this.setOnRequestCycle();
    }

    public PageParameters(Map parameterMap) {
        super(parameterMap);
        this.setOnRequestCycle();
    }

    public PageParameters(String keyValuePairs) {
        this(keyValuePairs, ",");
    }

    public PageParameters(String keyValuePairs, String delimiter) {
        this.setOnRequestCycle();
        StringList pairs = StringList.tokenize(keyValuePairs, delimiter);
        IStringIterator iterator = pairs.iterator();
        while (iterator.hasNext()) {
            String value;
            String key;
            String pair = iterator.next();
            int pos = pair.indexOf(61);
            if (pos == 0) {
                throw new IllegalArgumentException("URL parameter is missing the lvalue: " + pair);
            }
            if (pos != -1) {
                key = pair.substring(0, pos).trim();
                value = pair.substring(pos + 1).trim();
                this.put(key, value);
                continue;
            }
            key = pair.trim();
            value = null;
            this.put(key, value);
        }
    }

    public Object put(Object key, Object value) {
        return super.put(key, value);
    }

    private void setOnRequestCycle() {
        RequestCycle cycle = RequestCycle.get();
        if (cycle != null) {
            cycle.setPageParameters(this);
        }
    }
}

