/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.authorization.strategies.page;

import java.lang.ref.WeakReference;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.authorization.strategies.page.AbstractPageAuthorizationStrategy;

public abstract class SimplePageAuthorizationStrategy
extends AbstractPageAuthorizationStrategy {
    private final WeakReference securePageSuperTypeRef;

    public SimplePageAuthorizationStrategy(Class securePageSuperType, final Class signInPageClass) {
        if (securePageSuperType == null) {
            throw new IllegalArgumentException("Secure page super type must not be null");
        }
        this.securePageSuperTypeRef = new WeakReference<Class>(securePageSuperType);
        Application.get().getSecuritySettings().setUnauthorizedComponentInstantiationListener(new IUnauthorizedComponentInstantiationListener(){

            public void onUnauthorizedInstantiation(Component component) {
                if (component instanceof Page) {
                    throw new RestartResponseAtInterceptPageException(signInPageClass);
                }
                throw new UnauthorizedInstantiationException(component.getClass());
            }
        });
    }

    protected boolean isPageAuthorized(Class pageClass) {
        if (this.instanceOf(pageClass, (Class)this.securePageSuperTypeRef.get())) {
            return this.isAuthorized();
        }
        return true;
    }

    protected abstract boolean isAuthorized();
}

