/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.list;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListItemModel;
import org.apache.wicket.markup.repeater.AbstractRepeater;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.collections.ReadOnlyIterator;
import org.apache.wicket.version.undo.Change;

public abstract class ListView
extends AbstractRepeater {
    private static final long serialVersionUID = 1L;
    private int firstIndex = 0;
    private boolean reuseItems = false;
    private int viewSize = Integer.MAX_VALUE;

    public ListView(String id) {
        super(id);
    }

    public ListView(String id, IModel model) {
        super(id, model);
        if (model == null) {
            throw new IllegalArgumentException("Null models are not allowed. If you have no model, you may prefer a Loop instead");
        }
    }

    public ListView(String id, List list) {
        this(id, new Model((Serializable)((Object)list)));
    }

    public final List getList() {
        List list = (List)this.getModelObject();
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public boolean getReuseItems() {
        return this.reuseItems;
    }

    public final int getStartIndex() {
        return this.firstIndex;
    }

    public int getViewSize() {
        int size = this.viewSize;
        Object modelObject = this.getModelObject();
        if (modelObject == null) {
            return size == Integer.MAX_VALUE ? 0 : size;
        }
        int modelSize = this.getList().size();
        if (this.firstIndex > modelSize) {
            return 0;
        }
        if (size == Integer.MAX_VALUE || this.firstIndex + size > modelSize) {
            size = modelSize - this.firstIndex;
        }
        if (Integer.MAX_VALUE - size < this.firstIndex) {
            throw new IllegalStateException("firstIndex + size must be smaller than Integer.MAX_VALUE");
        }
        return size;
    }

    public final Link moveDownLink(String id, final ListItem item) {
        return new Link(id){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                int index = ListView.this.getList().indexOf(item.getModelObject());
                if (index != -1) {
                    this.addStateChange(new Change(this, index){
                        private static final long serialVersionUID = 1L;
                        final int oldIndex;
                        private final /* synthetic */ int val$index;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$index = val$index;
                            this.oldIndex = this.val$index;
                        }

                        public void undo() {
                            Collections.swap(1.access$000(this.this$1).getList(), this.oldIndex + 1, this.oldIndex);
                        }
                    });
                    Collections.swap(ListView.this.getList(), index, index + 1);
                    ListView.this.removeAll();
                }
            }

            protected void onBeforeRender() {
                super.onBeforeRender();
                this.setAutoEnable(false);
                if (ListView.this.getList().indexOf(item.getModelObject()) == ListView.this.getList().size() - 1) {
                    this.setEnabled(false);
                }
            }

            static /* synthetic */ ListView access$000(1 x0) {
                return x0.ListView.this;
            }
        };
    }

    public final Link moveUpLink(String id, final ListItem item) {
        return new Link(id){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                int index = ListView.this.getList().indexOf(item.getModelObject());
                if (index != -1) {
                    this.addStateChange(new Change(this, index){
                        private static final long serialVersionUID = 1L;
                        final int oldIndex;
                        private final /* synthetic */ int val$index;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$index = val$index;
                            this.oldIndex = this.val$index;
                        }

                        public void undo() {
                            Collections.swap(3.access$100(this.this$1).getList(), this.oldIndex - 1, this.oldIndex);
                        }
                    });
                    Collections.swap(ListView.this.getList(), index, index - 1);
                    ListView.this.removeAll();
                }
            }

            protected void onBeforeRender() {
                super.onBeforeRender();
                this.setAutoEnable(false);
                if (ListView.this.getList().indexOf(item.getModelObject()) == 0) {
                    this.setEnabled(false);
                }
            }

            static /* synthetic */ ListView access$100(3 x0) {
                return x0.ListView.this;
            }
        };
    }

    public final Link removeLink(String id, final ListItem item) {
        return new Link(id){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                this.addStateChange(new Change(this){
                    private static final long serialVersionUID = 1L;
                    final int oldIndex;
                    final Object removedObject;
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                        this.oldIndex = 5.access$300(this.this$1).getList().indexOf(5.access$200(this.this$1).getModelObject());
                        this.removedObject = 5.access$200(this.this$1).getModelObject();
                    }

                    public void undo() {
                        5.access$300(this.this$1).getList().add(this.oldIndex, this.removedObject);
                    }
                });
                item.modelChanging();
                ListView.this.getList().remove(item.getModelObject());
                ListView.this.modelChanged();
                ListView.this.removeAll();
            }

            static /* synthetic */ ListItem access$200(5 x0) {
                return x0.item;
            }

            static /* synthetic */ ListView access$300(5 x0) {
                return x0.ListView.this;
            }
        };
    }

    public Component setList(List list) {
        return this.setModel(new Model((Serializable)((Object)list)));
    }

    public Component setModel(IModel model) {
        return super.setModel(model);
    }

    public ListView setReuseItems(boolean reuseItems) {
        this.reuseItems = reuseItems;
        return this;
    }

    public ListView setStartIndex(int startIndex) {
        this.firstIndex = startIndex;
        if (this.firstIndex < 0) {
            this.firstIndex = 0;
        } else if (this.firstIndex > this.getList().size()) {
            this.firstIndex = 0;
        }
        return this;
    }

    public ListView setViewSize(int size) {
        this.viewSize = size;
        if (this.viewSize < 0) {
            this.viewSize = Integer.MAX_VALUE;
        }
        return this;
    }

    protected IModel getListItemModel(IModel listViewModel, int index) {
        return new ListItemModel(this, index);
    }

    protected ListItem newItem(int index) {
        return new ListItem(index, this.getListItemModel(this.getModel(), index));
    }

    protected final void onPopulate() {
        int size = this.getViewSize();
        if (size > 0) {
            if (this.getReuseItems()) {
                int maxIndex = this.firstIndex + size;
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    int index;
                    ListItem child = (ListItem)iterator.next();
                    if (child == null || (index = child.getIndex()) >= this.firstIndex && index < maxIndex) continue;
                    iterator.remove();
                }
            } else {
                this.removeAll();
            }
            boolean hasChildren = this.size() != 0;
            for (int i = 0; i < size; ++i) {
                int index = this.firstIndex + i;
                ListItem item = null;
                if (hasChildren) {
                    item = (ListItem)this.get(Integer.toString(index));
                }
                if (item != null) continue;
                item = this.newItem(index);
                this.add(item);
                this.onBeginPopulateItem(item);
                this.populateItem(item);
            }
        } else {
            this.removeAll();
        }
    }

    protected void onBeginPopulateItem(ListItem item) {
    }

    protected abstract void populateItem(ListItem var1);

    protected final void renderChild(Component child) {
        this.renderItem((ListItem)child);
    }

    protected void renderItem(ListItem item) {
        item.render(this.getMarkupStream());
    }

    protected Iterator renderIterator() {
        final int size = this.size();
        return new ReadOnlyIterator(){
            private int index = 0;

            public boolean hasNext() {
                return this.index < size;
            }

            public Object next() {
                String id = Integer.toString(ListView.this.firstIndex + this.index);
                ++this.index;
                Component c = ListView.this.get(id);
                return c;
            }
        };
    }
}

