/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.pages;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.pages.BrowserInfoForm;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.ClientProperties;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.request.ClientInfo;
import org.apache.wicket.request.target.basic.RedirectRequestTarget;
import org.apache.wicket.request.target.component.BookmarkablePageRequestTarget;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserInfoPage
extends WebPage {
    private static final Logger log = LoggerFactory.getLogger((Class)BrowserInfoPage.class);
    private static final long serialVersionUID = 1L;
    private String continueTo;

    public BrowserInfoPage(PageParameters parameters) {
        String to = Strings.toString(parameters.get("cto"));
        if (to == null) {
            throw new IllegalArgumentException("parameter cto must be provided!");
        }
        this.setContinueTo(to);
        this.initComps();
        WebRequestCycle requestCycle = (WebRequestCycle)this.getRequestCycle();
        WebSession session = (WebSession)this.getSession();
        ClientInfo clientInfo = session.getClientInfo();
        if (clientInfo == null) {
            clientInfo = new WebClientInfo(requestCycle);
            this.getSession().setClientInfo(clientInfo);
        } else if (clientInfo instanceof WebClientInfo) {
            WebClientInfo info = (WebClientInfo)clientInfo;
            ClientProperties properties = info.getProperties();
            properties.setJavaEnabled(false);
        } else {
            this.warnNotUsingWebClientInfo(clientInfo);
        }
        this.continueToPrevious();
    }

    public BrowserInfoPage(String continueTo) {
        if (continueTo == null) {
            throw new IllegalArgumentException("Argument continueTo must be not null");
        }
        this.setContinueTo(continueTo);
        this.initComps();
    }

    public boolean isVersioned() {
        return false;
    }

    private final void initComps() {
        WebComponent meta = new WebComponent("meta");
        PageParameters parameters = new PageParameters();
        parameters.put("cto", this.continueTo);
        CharSequence url = this.urlFor(new BookmarkablePageRequestTarget(BrowserInfoPage.class, parameters));
        meta.add(new AttributeModifier("content", true, (IModel)new Model((Serializable)((Object)("0; url=" + url)))));
        this.add(meta);
        WebMarkupContainer link = new WebMarkupContainer("link");
        link.add(new AttributeModifier("href", true, (IModel)new Model((Serializable)((Object)url))));
        this.add(link);
        this.add(new BrowserInfoForm("postback"){
            private static final long serialVersionUID = 1L;

            protected void afterSubmit() {
                BrowserInfoPage.this.continueToPrevious();
            }
        });
    }

    protected final void continueToPrevious() {
        RequestCycle.get().setRequestTarget(new RedirectRequestTarget(this.continueTo));
    }

    void warnNotUsingWebClientInfo(ClientInfo clientInfo) {
        log.warn("using " + this.getClass().getName() + " makes no sense if you are not using " + WebClientInfo.class.getName() + " (you are using " + clientInfo.getClass().getName() + " instead)");
    }

    protected final void setContinueTo(String continueTo) {
        this.continueTo = continueTo;
    }
}

