/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.repeater.data;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ListDataProvider
implements IDataProvider {
    private static final long serialVersionUID = 1L;
    private final List list;

    public ListDataProvider(List list) {
        if (list == null) {
            throw new IllegalArgumentException("argument [list] cannot be null");
        }
        this.list = list;
    }

    public Iterator iterator(int first, int count) {
        int toIndex = first + count;
        if (toIndex > this.list.size()) {
            toIndex = this.list.size();
        }
        return this.list.subList(first, toIndex).listIterator();
    }

    public int size() {
        return this.list.size();
    }

    public IModel model(Object object) {
        return new Model((Serializable)object);
    }

    public void detach() {
    }
}

