/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.request.urlcompressing;

import org.apache.wicket.Component;
import org.apache.wicket.IRedirectListener;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authorization.UnauthorizedActionException;
import org.apache.wicket.markup.html.INewBrowserWindowListener;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebRequestCycleProcessor;
import org.apache.wicket.protocol.http.request.urlcompressing.UrlCompressingWebCodingStrategy;
import org.apache.wicket.protocol.http.request.urlcompressing.UrlCompressor;
import org.apache.wicket.request.IRequestCodingStrategy;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.component.listener.RedirectPageRequestTarget;
import org.apache.wicket.util.string.Strings;

public class UrlCompressingWebRequestProcessor
extends WebRequestCycleProcessor {
    protected IRequestCodingStrategy newRequestCodingStrategy() {
        return new UrlCompressingWebCodingStrategy();
    }

    protected IRequestTarget resolveListenerInterfaceTarget(RequestCycle requestCycle, Page page, String componentPath, String interfaceName, RequestParameters requestParameters) {
        UrlCompressor.ComponentAndInterface cai;
        String pageRelativeComponentPath = Strings.afterFirstPathComponent(componentPath, ':');
        Component component = null;
        if (page instanceof WebPage && !"IResourceListener".equals(interfaceName) && (cai = ((WebPage)page).getUrlCompressor().getComponentAndInterfaceForUID(pageRelativeComponentPath)) != null) {
            interfaceName = cai.getInterfaceName();
            component = cai.getComponent();
        }
        requestParameters.setInterfaceName(interfaceName);
        if (interfaceName.equals(IRedirectListener.INTERFACE.getName())) {
            return new RedirectPageRequestTarget(page);
        }
        if (interfaceName.equals(INewBrowserWindowListener.INTERFACE.getName())) {
            return INewBrowserWindowListener.INTERFACE.newRequestTarget(page, page, INewBrowserWindowListener.INTERFACE, requestParameters);
        }
        RequestListenerInterface listener = RequestListenerInterface.forName(interfaceName);
        if (listener == null) {
            throw new WicketRuntimeException("Attempt to access unknown request listener interface " + interfaceName);
        }
        if (component == null) {
            component = Strings.isEmpty(pageRelativeComponentPath) ? page : page.get(pageRelativeComponentPath);
        }
        if (component == null) {
            throw new WicketRuntimeException("cannot resolve component with path '" + pageRelativeComponentPath + "', listener " + listener + " on page " + page);
        }
        if (!component.isEnableAllowed()) {
            throw new UnauthorizedActionException(component, Component.ENABLE);
        }
        return listener.newRequestTarget(page, component, listener, requestParameters);
    }
}

