/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.util.tester.WicketTester;

public class ExternalPageViewer {
    private static final List browserPaths = new ArrayList();
    private final WicketTester tester;

    public ExternalPageViewer(WicketTester tester) {
        this.tester = tester;
    }

    public static final void registerBrowserPath(String path) {
        browserPaths.add(path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void viewInBrowser() {
        block8: {
            int webRootPathIndex = this.getThisClassFileURL().getPath().indexOf("/WEB-INF");
            String webRootPath = this.getThisClassFileURL().getPath().substring(0, webRootPathIndex);
            File temp = new File(webRootPath + "/" + this.getTemperaryDumpHtmlFileName());
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(temp);
                    out.write(this.tester.getServletResponse().getDocument().getBytes(this.getHtmlEncoding()));
                    out.flush();
                }
                catch (UnsupportedEncodingException e) {
                    throw this.convertoUnexpect(e);
                }
                catch (IOException e) {
                    throw this.convertoUnexpect(e);
                }
                Object var7_5 = null;
                if (out == null) break block8;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (out == null) throw throwable;
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw this.convertoUnexpect(e);
                }
            }
            try {}
            catch (IOException e) {
                throw this.convertoUnexpect(e);
            }
            out.close();
        }
        if (new File(this.getBrowserPath()).exists()) throw new RuntimeException("Not yet supported");
        throw new IllegalStateException("No browser found at " + this.getBrowserPath());
    }

    private String getBrowserPath() {
        Iterator iter = browserPaths.iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            if (!new File(path).exists()) continue;
            return path;
        }
        throw new IllegalStateException("No browser found, please add definition");
    }

    protected String getTemperaryDumpHtmlFileName() {
        return ".del-wicketTestDump.html";
    }

    protected String getHtmlEncoding() {
        return "UTF-8";
    }

    private URL getThisClassFileURL() {
        URL url = this.getClass().getClassLoader().getResource(this.getClass().getName().replace('.', '/') + ".class");
        return url;
    }

    private RuntimeException convertoUnexpect(Exception e) {
        return new RuntimeException("tester: unexpect", e);
    }

    static {
        ExternalPageViewer.registerBrowserPath("C:/Program Files/Mozilla Firefox/firefox.exe");
        ExternalPageViewer.registerBrowserPath("C:/Program Files/Internet Explorer/iexplore.exe");
    }
}

