/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.time;

import org.apache.wicket.util.time.AbstractTimeValue;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.ITimeFrameSource;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.time.TimeOfDay;

public final class TimeFrame
implements ITimeFrameSource {
    private final Time end;
    private final Time start;

    public static ITimeFrameSource eachDay(final TimeOfDay startTimeOfDay, final TimeOfDay endTimeOfDay) {
        TimeFrame.check(startTimeOfDay, endTimeOfDay);
        return new ITimeFrameSource(){

            public TimeFrame getTimeFrame() {
                return new TimeFrame(Time.valueOf(startTimeOfDay), Time.valueOf(endTimeOfDay));
            }
        };
    }

    public static TimeFrame valueOf(Time start, Duration duration) {
        return new TimeFrame(start, start.add(duration));
    }

    public static TimeFrame valueOf(Time start, Time end) {
        return new TimeFrame(start, end);
    }

    private static void check(AbstractTimeValue start, AbstractTimeValue end) {
        if (end.lessThan(start)) {
            throw new IllegalArgumentException("Start time of time frame " + start + " was after end time " + end);
        }
    }

    private TimeFrame(Time start, Time end) {
        TimeFrame.check(start, end);
        this.start = start;
        this.end = end;
    }

    public boolean contains(Time time) {
        return (this.start.equals(time) || this.start.before(time)) && this.end.after(time);
    }

    public Duration getDuration() {
        return this.end.subtract(this.start);
    }

    public Time getEnd() {
        return this.end;
    }

    public Time getStart() {
        return this.start;
    }

    public TimeFrame getTimeFrame() {
        return this;
    }

    public boolean overlaps(TimeFrame timeframe) {
        return this.contains(timeframe.start) || this.contains(timeframe.end) || timeframe.contains(this.start) || timeframe.contains(this.end);
    }

    public String toString() {
        return "[start=" + this.start + ", end=" + this.end + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeFrame other = (TimeFrame)obj;
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        return !(this.start == null ? other.start != null : !this.start.equals(other.start));
    }
}

