/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.value;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.wicket.util.parse.metapattern.MetaPattern;
import org.apache.wicket.util.parse.metapattern.parsers.VariableAssignmentParser;
import org.apache.wicket.util.string.IStringIterator;
import org.apache.wicket.util.string.StringList;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.StringValueConversionException;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.value.IValueMap;

public class ValueMap
extends HashMap
implements IValueMap {
    public static final ValueMap EMPTY_MAP = new ValueMap();
    private static final long serialVersionUID = 1L;
    private boolean immutable = false;

    public ValueMap() {
    }

    public ValueMap(Map map) {
        super.putAll(map);
    }

    public ValueMap(String keyValuePairs) {
        this(keyValuePairs, ",");
    }

    public ValueMap(String keyValuePairs, String delimiter) {
        int start = 0;
        int equalsIndex = keyValuePairs.indexOf(61);
        int delimiterIndex = keyValuePairs.indexOf(delimiter, equalsIndex);
        if (delimiterIndex == -1) {
            delimiterIndex = keyValuePairs.length();
        }
        while (equalsIndex != -1) {
            if (delimiterIndex < keyValuePairs.length()) {
                int delimiterIndex2;
                int equalsIndex2 = keyValuePairs.indexOf(61, delimiterIndex + 1);
                delimiterIndex = equalsIndex2 != -1 ? (delimiterIndex2 = keyValuePairs.lastIndexOf(delimiter, equalsIndex2)) : keyValuePairs.length();
            }
            String key = keyValuePairs.substring(start, equalsIndex);
            String value = keyValuePairs.substring(equalsIndex + 1, delimiterIndex);
            this.put(key, value);
            if (delimiterIndex < keyValuePairs.length()) {
                start = delimiterIndex + 1;
                equalsIndex = keyValuePairs.indexOf(61, start);
                if (equalsIndex == -1 || (delimiterIndex = keyValuePairs.indexOf(delimiter, equalsIndex)) != -1) continue;
                delimiterIndex = keyValuePairs.length();
                continue;
            }
            equalsIndex = -1;
        }
    }

    public ValueMap(String keyValuePairs, String delimiter, MetaPattern valuePattern) {
        StringList pairs = StringList.tokenize(keyValuePairs, delimiter);
        IStringIterator iterator = pairs.iterator();
        while (iterator.hasNext()) {
            String pair = iterator.next();
            VariableAssignmentParser parser = new VariableAssignmentParser(pair, valuePattern);
            if (parser.matches()) {
                this.put(parser.getKey(), parser.getValue());
                continue;
            }
            throw new IllegalArgumentException("Invalid key value list: '" + keyValuePairs + "'");
        }
    }

    public final void clear() {
        this.checkMutability();
        super.clear();
    }

    public final boolean getBoolean(String key) throws StringValueConversionException {
        return this.getStringValue(key).toBoolean();
    }

    public final double getDouble(String key) throws StringValueConversionException {
        return this.getStringValue(key).toDouble();
    }

    public final double getDouble(String key, double defaultValue) throws StringValueConversionException {
        return this.getStringValue(key).toDouble(defaultValue);
    }

    public final Duration getDuration(String key) throws StringValueConversionException {
        return this.getStringValue(key).toDuration();
    }

    public final int getInt(String key) throws StringValueConversionException {
        return this.getStringValue(key).toInt();
    }

    public final int getInt(String key, int defaultValue) throws StringValueConversionException {
        return this.getStringValue(key).toInt(defaultValue);
    }

    public final long getLong(String key) throws StringValueConversionException {
        return this.getStringValue(key).toLong();
    }

    public final long getLong(String key, long defaultValue) throws StringValueConversionException {
        return this.getStringValue(key).toLong(defaultValue);
    }

    public final String getString(String key, String defaultValue) {
        String value = this.getString(key);
        return value != null ? value : defaultValue;
    }

    public final String getString(String key) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        if (o.getClass().isArray() && Array.getLength(o) > 0) {
            Object arrayValue = Array.get(o, 0);
            if (arrayValue == null) {
                return null;
            }
            return arrayValue.toString();
        }
        return o.toString();
    }

    public final CharSequence getCharSequence(String key) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        if (o.getClass().isArray() && Array.getLength(o) > 0) {
            Object arrayValue = Array.get(o, 0);
            if (arrayValue == null) {
                return null;
            }
            if (arrayValue instanceof CharSequence) {
                return (CharSequence)arrayValue;
            }
            return arrayValue.toString();
        }
        if (o instanceof CharSequence) {
            return (CharSequence)o;
        }
        return o.toString();
    }

    public String[] getStringArray(String key) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof String[]) {
            return (String[])o;
        }
        if (o.getClass().isArray()) {
            int length = Array.getLength(o);
            String[] array = new String[length];
            for (int i = 0; i < length; ++i) {
                Object arrayValue = Array.get(o, i);
                if (arrayValue == null) continue;
                array[i] = arrayValue.toString();
            }
            return array;
        }
        return new String[]{o.toString()};
    }

    public StringValue getStringValue(String key) {
        return StringValue.valueOf(this.getString(key));
    }

    public final Time getTime(String key) throws StringValueConversionException {
        return this.getStringValue(key).toTime();
    }

    public final boolean isImmutable() {
        return this.immutable;
    }

    public final IValueMap makeImmutable() {
        this.immutable = true;
        return this;
    }

    public Object put(Object key, Object value) {
        this.checkMutability();
        return super.put(key, value);
    }

    public final Object add(String key, String value) {
        this.checkMutability();
        Object o = this.get(key);
        if (o == null) {
            return this.put(key, value);
        }
        if (o.getClass().isArray()) {
            int length = Array.getLength(o);
            String[] destArray = new String[length + 1];
            for (int i = 0; i < length; ++i) {
                Object arrayValue = Array.get(o, i);
                if (arrayValue == null) continue;
                destArray[i] = arrayValue.toString();
            }
            destArray[length] = value;
            return this.put(key, destArray);
        }
        return this.put(key, new String[]{o.toString(), value});
    }

    public void putAll(Map map) {
        this.checkMutability();
        super.putAll(map);
    }

    public Object remove(Object key) {
        this.checkMutability();
        return super.remove(key);
    }

    public String getKey(String key) {
        Iterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            String keyString;
            Object keyValue = iter.next();
            if (!(keyValue instanceof String) || !key.equalsIgnoreCase(keyString = (String)keyValue)) continue;
            return keyString;
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            buffer.append(entry.getKey());
            buffer.append(" = \"");
            Object value = entry.getValue();
            if (value == null) {
                buffer.append("null");
            } else if (value.getClass().isArray()) {
                buffer.append(Arrays.asList((Object[])value));
            } else {
                buffer.append(value);
            }
            buffer.append("\"");
            if (!iterator.hasNext()) continue;
            buffer.append(' ');
        }
        return buffer.toString();
    }

    private final void checkMutability() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Map is immutable");
        }
    }
}

