/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility;

import java.util.concurrent.TimeUnit;
import org.awaitility.Duration;
import org.awaitility.constraint.AtMostWaitConstraint;
import org.awaitility.constraint.WaitConstraint;
import org.awaitility.core.CheckedExceptionRethrower;
import org.awaitility.core.ConditionEvaluationListener;
import org.awaitility.core.ConditionFactory;
import org.awaitility.core.ExceptionIgnorer;
import org.awaitility.core.FieldSupplierBuilder;
import org.awaitility.core.HamcrestExceptionIgnorer;
import org.awaitility.core.MethodCallRecorder;
import org.awaitility.core.Predicate;
import org.awaitility.core.PredicateExceptionIgnorer;
import org.awaitility.core.ThrowingRunnable;
import org.awaitility.pollinterval.FixedPollInterval;
import org.awaitility.pollinterval.PollInterval;
import org.hamcrest.Matcher;

public class Awaitility {
    private static final Duration DEFAULT_POLL_DELAY = null;
    private static final PollInterval DEFAULT_POLL_INTERVAL;
    private static volatile PollInterval defaultPollInterval;
    private static volatile WaitConstraint defaultWaitConstraint;
    private static volatile Duration defaultPollDelay;
    private static volatile boolean defaultCatchUncaughtExceptions;
    private static volatile ExceptionIgnorer defaultExceptionIgnorer;
    private static volatile ConditionEvaluationListener defaultConditionEvaluationListener;

    public static void catchUncaughtExceptionsByDefault() {
        defaultCatchUncaughtExceptions = true;
    }

    public static void doNotCatchUncaughtExceptionsByDefault() {
        defaultCatchUncaughtExceptions = false;
    }

    public static void ignoreExceptionsByDefault() {
        defaultExceptionIgnorer = new PredicateExceptionIgnorer(new Predicate<Exception>(){

            @Override
            public boolean matches(Exception e) {
                return true;
            }
        });
    }

    public static void ignoreExceptionByDefault(final Class<? extends Exception> exceptionType) {
        defaultExceptionIgnorer = new PredicateExceptionIgnorer(new Predicate<Exception>(){

            @Override
            public boolean matches(Exception e) {
                return e.getClass().equals(exceptionType);
            }
        });
    }

    public static void ignoreExceptionsByDefaultMatching(Predicate<Exception> predicate) {
        defaultExceptionIgnorer = new PredicateExceptionIgnorer(predicate);
    }

    public static void ignoreExceptionsByDefaultMatching(Matcher<? super Exception> matcher) {
        defaultExceptionIgnorer = new HamcrestExceptionIgnorer(matcher);
    }

    public static void reset() {
        defaultPollInterval = DEFAULT_POLL_INTERVAL;
        defaultPollDelay = DEFAULT_POLL_DELAY;
        defaultWaitConstraint = AtMostWaitConstraint.TEN_SECONDS;
        defaultCatchUncaughtExceptions = true;
        defaultConditionEvaluationListener = null;
        defaultExceptionIgnorer = new PredicateExceptionIgnorer(new Predicate<Exception>(){

            @Override
            public boolean matches(Exception e) {
                return false;
            }
        });
        Thread.setDefaultUncaughtExceptionHandler(null);
        MethodCallRecorder.reset();
    }

    public static ConditionFactory await() {
        return Awaitility.await(null);
    }

    public static ConditionFactory await(String alias) {
        return new ConditionFactory(alias, defaultWaitConstraint, defaultPollInterval, defaultPollDelay, defaultCatchUncaughtExceptions, defaultExceptionIgnorer, defaultConditionEvaluationListener);
    }

    public static ConditionFactory catchUncaughtExceptions() {
        return new ConditionFactory(defaultWaitConstraint, defaultPollInterval, defaultPollDelay, true, defaultExceptionIgnorer);
    }

    public static ConditionFactory dontCatchUncaughtExceptions() {
        return new ConditionFactory(defaultWaitConstraint, defaultPollInterval, defaultPollDelay, false, defaultExceptionIgnorer);
    }

    public static ConditionFactory with() {
        return new ConditionFactory(defaultWaitConstraint, defaultPollInterval, defaultPollDelay, defaultCatchUncaughtExceptions, defaultExceptionIgnorer, defaultConditionEvaluationListener);
    }

    public static ConditionFactory given() {
        return new ConditionFactory(defaultWaitConstraint, defaultPollInterval, defaultPollDelay, defaultCatchUncaughtExceptions, defaultExceptionIgnorer);
    }

    public static ConditionFactory waitAtMost(Duration timeout) {
        return new ConditionFactory(defaultWaitConstraint.withMaxWaitTime(timeout), defaultPollInterval, defaultPollDelay, defaultCatchUncaughtExceptions, defaultExceptionIgnorer);
    }

    public static ConditionFactory waitAtMost(long value, TimeUnit unit) {
        return new ConditionFactory(defaultWaitConstraint.withMaxWaitTime(new Duration(value, unit)), defaultPollInterval, defaultPollDelay, defaultCatchUncaughtExceptions, defaultExceptionIgnorer);
    }

    public static void setDefaultPollInterval(long pollInterval, TimeUnit unit) {
        defaultPollInterval = new FixedPollInterval(new Duration(pollInterval, unit));
    }

    public static void setDefaultPollDelay(long pollDelay, TimeUnit unit) {
        defaultPollDelay = new Duration(pollDelay, unit);
    }

    public static void setDefaultTimeout(long timeout, TimeUnit unit) {
        defaultWaitConstraint = defaultWaitConstraint.withMaxWaitTime(new Duration(timeout, unit));
    }

    public static void setDefaultPollInterval(Duration pollInterval) {
        if (pollInterval == null) {
            throw new IllegalArgumentException("You must specify a poll interval (was null).");
        }
        defaultPollInterval = new FixedPollInterval(pollInterval);
    }

    public static void setDefaultPollInterval(PollInterval pollInterval) {
        if (pollInterval == null) {
            throw new IllegalArgumentException("You must specify a poll interval (was null).");
        }
        defaultPollInterval = pollInterval;
    }

    public static void setDefaultPollDelay(Duration pollDelay) {
        if (pollDelay == null) {
            throw new IllegalArgumentException("You must specify a poll delay (was null).");
        }
        defaultPollDelay = pollDelay;
    }

    public static void setDefaultTimeout(Duration defaultTimeout) {
        if (defaultTimeout == null) {
            throw new IllegalArgumentException("You must specify a default timeout (was null).");
        }
        defaultWaitConstraint = defaultWaitConstraint.withMaxWaitTime(defaultTimeout);
    }

    public static void setDefaultConditionEvaluationListener(ConditionEvaluationListener defaultConditionEvaluationListener) {
        Awaitility.defaultConditionEvaluationListener = defaultConditionEvaluationListener;
    }

    public static <S> S to(S object) {
        return (S)MethodCallRecorder.createProxy(object);
    }

    public static Runnable matches(final ThrowingRunnable throwingRunnable) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    throwingRunnable.run();
                }
                catch (Throwable e) {
                    CheckedExceptionRethrower.safeRethrow(e);
                }
            }
        };
    }

    public static FieldSupplierBuilder fieldIn(Object object) {
        return new FieldSupplierBuilder(object);
    }

    public static FieldSupplierBuilder fieldIn(Class<?> clazz) {
        return new FieldSupplierBuilder(clazz);
    }

    static {
        defaultPollInterval = DEFAULT_POLL_INTERVAL = new FixedPollInterval(Duration.ONE_HUNDRED_MILLISECONDS);
        defaultWaitConstraint = AtMostWaitConstraint.TEN_SECONDS;
        defaultPollDelay = DEFAULT_POLL_DELAY;
        defaultCatchUncaughtExceptions = true;
        defaultExceptionIgnorer = new PredicateExceptionIgnorer(new Predicate<Exception>(){

            @Override
            public boolean matches(Exception e) {
                return false;
            }
        });
        defaultConditionEvaluationListener = null;
    }
}

