/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.core;

import java.util.concurrent.Callable;
import org.awaitility.Duration;
import org.awaitility.core.Condition;
import org.awaitility.core.ConditionAwaiter;
import org.awaitility.core.ConditionEvaluationHandler;
import org.awaitility.core.ConditionEvaluator;
import org.awaitility.core.ConditionSettings;
import org.awaitility.core.HamcrestToStringFilter;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

abstract class AbstractHamcrestCondition<T>
implements Condition<T> {
    private ConditionAwaiter conditionAwaiter;
    private T lastResult;
    private final ConditionEvaluationHandler<T> conditionEvaluationHandler;

    public AbstractHamcrestCondition(final Callable<T> supplier, final Matcher<? super T> matcher, ConditionSettings settings) {
        if (supplier == null) {
            throw new IllegalArgumentException("You must specify a supplier (was null).");
        }
        if (matcher == null) {
            throw new IllegalArgumentException("You must specify a matcher (was null).");
        }
        this.conditionEvaluationHandler = new ConditionEvaluationHandler<T>(matcher, settings);
        ConditionEvaluator callable = new ConditionEvaluator(){

            @Override
            public boolean eval(Duration pollInterval) throws Exception {
                AbstractHamcrestCondition.this.lastResult = supplier.call();
                boolean matches = matcher.matches(AbstractHamcrestCondition.this.lastResult);
                if (matches) {
                    AbstractHamcrestCondition.this.conditionEvaluationHandler.handleConditionResultMatch(AbstractHamcrestCondition.this.getMatchMessage(supplier, matcher), AbstractHamcrestCondition.this.lastResult, pollInterval);
                } else {
                    AbstractHamcrestCondition.this.conditionEvaluationHandler.handleConditionResultMismatch(AbstractHamcrestCondition.this.getMismatchMessage(supplier, matcher), AbstractHamcrestCondition.this.lastResult, pollInterval);
                }
                return matches;
            }
        };
        this.conditionAwaiter = new ConditionAwaiter(callable, settings){

            @Override
            protected String getTimeoutMessage() {
                return String.format("%s expected %s but was <%s>", AbstractHamcrestCondition.this.getCallableDescription(supplier), HamcrestToStringFilter.filter(matcher), AbstractHamcrestCondition.this.lastResult);
            }
        };
    }

    private String getMatchMessage(Callable<T> supplier, Matcher<? super T> matcher) {
        return String.format("%s reached its end value of %s", this.getCallableDescription(supplier), HamcrestToStringFilter.filter(matcher));
    }

    private String getMismatchMessage(Callable<T> supplier, Matcher<? super T> matcher) {
        StringDescription mismatchDescription = new StringDescription();
        matcher.describeMismatch(this.lastResult, (Description)mismatchDescription);
        return String.format("%s expected %s but %s", this.getCallableDescription(supplier), HamcrestToStringFilter.filter(matcher), mismatchDescription);
    }

    @Override
    public T await() {
        this.conditionAwaiter.await(this.conditionEvaluationHandler);
        return this.lastResult;
    }

    abstract String getCallableDescription(Callable<T> var1);
}

