/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.awaitility.Duration;
import org.awaitility.constraint.AtMostWaitConstraint;
import org.awaitility.constraint.WaitConstraint;
import org.awaitility.core.AssertionCondition;
import org.awaitility.core.CallableCondition;
import org.awaitility.core.CallableHamcrestCondition;
import org.awaitility.core.CheckedExceptionRethrower;
import org.awaitility.core.Condition;
import org.awaitility.core.ConditionEvaluationListener;
import org.awaitility.core.ConditionSettings;
import org.awaitility.core.ExceptionIgnorer;
import org.awaitility.core.HamcrestExceptionIgnorer;
import org.awaitility.core.MethodCallRecorder;
import org.awaitility.core.Predicate;
import org.awaitility.core.PredicateExceptionIgnorer;
import org.awaitility.core.ProxyHamcrestCondition;
import org.awaitility.pollinterval.FixedPollInterval;
import org.awaitility.pollinterval.PollInterval;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class ConditionFactory {
    private final WaitConstraint timeoutConstraint;
    private final PollInterval pollInterval;
    private final boolean catchUncaughtExceptions;
    private final ExceptionIgnorer exceptionsIgnorer;
    private final String alias;
    private final Duration pollDelay;
    private final ConditionEvaluationListener conditionEvaluationListener;

    public ConditionFactory(String alias, WaitConstraint timeoutConstraint, Duration pollInterval, Duration pollDelay, boolean catchUncaughtExceptions, ExceptionIgnorer exceptionsIgnorer, ConditionEvaluationListener conditionEvaluationListener) {
        this(alias, timeoutConstraint, new FixedPollInterval(pollInterval), pollDelay, catchUncaughtExceptions, exceptionsIgnorer, conditionEvaluationListener);
    }

    public ConditionFactory(String alias, WaitConstraint timeoutConstraint, PollInterval pollInterval, Duration pollDelay, boolean catchUncaughtExceptions, ExceptionIgnorer exceptionsIgnorer, ConditionEvaluationListener conditionEvaluationListener) {
        if (pollInterval == null) {
            throw new IllegalArgumentException("pollInterval cannot be null");
        }
        if (timeoutConstraint == null) {
            throw new IllegalArgumentException("timeout cannot be null");
        }
        this.alias = alias;
        this.timeoutConstraint = timeoutConstraint;
        this.pollInterval = pollInterval;
        this.catchUncaughtExceptions = catchUncaughtExceptions;
        this.pollDelay = pollDelay;
        this.conditionEvaluationListener = conditionEvaluationListener;
        this.exceptionsIgnorer = exceptionsIgnorer;
    }

    public ConditionFactory(WaitConstraint timeoutConstraint, Duration pollInterval, Duration pollDelay, boolean catchUncaughtExceptions, ExceptionIgnorer exceptionsIgnorer) {
        this(null, timeoutConstraint, new FixedPollInterval(pollInterval), pollDelay, catchUncaughtExceptions, exceptionsIgnorer, null);
    }

    public ConditionFactory(WaitConstraint timeoutConstraint, PollInterval pollInterval, Duration pollDelay, boolean catchUncaughtExceptions, ExceptionIgnorer exceptionsIgnorer) {
        this(null, timeoutConstraint, pollInterval, pollDelay, catchUncaughtExceptions, exceptionsIgnorer, null);
    }

    public ConditionFactory(WaitConstraint timeoutConstraint, Duration pollInterval, Duration pollDelay, boolean catchUncaughtExceptions, ExceptionIgnorer exceptionsIgnorer, ConditionEvaluationListener conditionEvaluationListener) {
        this(null, timeoutConstraint, pollInterval, pollDelay, catchUncaughtExceptions, exceptionsIgnorer, conditionEvaluationListener);
    }

    public ConditionFactory(WaitConstraint timeoutConstraint, PollInterval pollInterval, Duration pollDelay, boolean catchUncaughtExceptions, ExceptionIgnorer exceptionsIgnorer, ConditionEvaluationListener conditionEvaluationListener) {
        this(null, timeoutConstraint, pollInterval, pollDelay, catchUncaughtExceptions, exceptionsIgnorer, conditionEvaluationListener);
    }

    public ConditionFactory conditionEvaluationListener(ConditionEvaluationListener conditionEvaluationListener) {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, conditionEvaluationListener);
    }

    public ConditionFactory timeout(Duration timeout) {
        return this.atMost(timeout);
    }

    public ConditionFactory atMost(Duration timeout) {
        return new ConditionFactory(this.alias, this.timeoutConstraint.withMaxWaitTime(timeout), this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory atLeast(Duration timeout) {
        return new ConditionFactory(this.alias, this.timeoutConstraint.withMinWaitTime(timeout), this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory atLeast(long timeout, TimeUnit unit) {
        return this.atLeast(new Duration(timeout, unit));
    }

    public ConditionFactory between(Duration atLeast, Duration atMost) {
        return this.atLeast(atLeast).and().atMost(atMost);
    }

    public ConditionFactory between(long atLeastDuration, TimeUnit atLeastTimeUnit, long atMostDuration, TimeUnit atMostTimeUnit) {
        return this.between(new Duration(atLeastDuration, atLeastTimeUnit), new Duration(atMostDuration, atMostTimeUnit));
    }

    public ConditionFactory forever() {
        return new ConditionFactory(this.alias, (WaitConstraint)AtMostWaitConstraint.FOREVER, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory pollInterval(Duration pollInterval) {
        return new ConditionFactory(this.alias, this.timeoutConstraint, pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory timeout(long timeout, TimeUnit unit) {
        return this.atMost(timeout, unit);
    }

    public ConditionFactory pollDelay(long delay, TimeUnit unit) {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, new Duration(delay, unit), this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory pollDelay(Duration pollDelay) {
        if (pollDelay == null) {
            throw new IllegalArgumentException("pollDelay cannot be null");
        }
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory atMost(long timeout, TimeUnit unit) {
        return this.atMost(new Duration(timeout, unit));
    }

    public ConditionFactory pollInterval(long pollInterval, TimeUnit unit) {
        FixedPollInterval fixedPollInterval = new FixedPollInterval(new Duration(pollInterval, unit));
        return new ConditionFactory(this.alias, this.timeoutConstraint, fixedPollInterval, this.definePollDelay(this.pollDelay, fixedPollInterval), this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory pollInterval(PollInterval pollInterval) {
        return new ConditionFactory(this.alias, this.timeoutConstraint, pollInterval, this.definePollDelay(this.pollDelay, pollInterval), this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory catchUncaughtExceptions() {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, true, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory ignoreExceptionsInstanceOf(final Class<? extends Exception> exceptionType) {
        if (exceptionType == null) {
            throw new IllegalArgumentException("exceptionType cannot be null");
        }
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, (ExceptionIgnorer)new PredicateExceptionIgnorer(new Predicate<Exception>(){

            @Override
            public boolean matches(Exception e) {
                return exceptionType.isAssignableFrom(e.getClass());
            }
        }), this.conditionEvaluationListener);
    }

    public ConditionFactory ignoreException(final Class<? extends Exception> exceptionType) {
        if (exceptionType == null) {
            throw new IllegalArgumentException("exception cannot be null");
        }
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, (ExceptionIgnorer)new PredicateExceptionIgnorer(new Predicate<Exception>(){

            @Override
            public boolean matches(Exception e) {
                return e.getClass().equals(exceptionType);
            }
        }), this.conditionEvaluationListener);
    }

    public ConditionFactory ignoreExceptions() {
        return this.ignoreExceptionsMatching(new Predicate<Exception>(){

            @Override
            public boolean matches(Exception e) {
                return true;
            }
        });
    }

    public ConditionFactory ignoreNoExceptions() {
        return this.ignoreExceptionsMatching(new Predicate<Exception>(){

            @Override
            public boolean matches(Exception e) {
                return false;
            }
        });
    }

    public ConditionFactory ignoreExceptionsMatching(Matcher<? super Exception> matcher) {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, (ExceptionIgnorer)new HamcrestExceptionIgnorer(matcher), this.conditionEvaluationListener);
    }

    public ConditionFactory ignoreExceptionsMatching(Predicate<Exception> predicate) {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, (ExceptionIgnorer)new PredicateExceptionIgnorer(predicate), this.conditionEvaluationListener);
    }

    public ConditionFactory await() {
        return this;
    }

    public ConditionFactory await(String alias) {
        return new ConditionFactory(alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory and() {
        return this;
    }

    public ConditionFactory with() {
        return this;
    }

    public ConditionFactory then() {
        return this;
    }

    public ConditionFactory given() {
        return this;
    }

    public ConditionFactory dontCatchUncaughtExceptions() {
        return new ConditionFactory(this.timeoutConstraint, this.pollInterval, this.pollDelay, false, this.exceptionsIgnorer);
    }

    public <T> T untilCall(T ignore, Matcher<? super T> matcher) {
        MethodCaller supplier = new MethodCaller(MethodCallRecorder.getLastTarget(), MethodCallRecorder.getLastMethod(), MethodCallRecorder.getLastArgs());
        MethodCallRecorder.reset();
        ProxyHamcrestCondition<? super T> proxyCondition = new ProxyHamcrestCondition<T>(supplier, matcher, this.generateConditionSettings());
        return this.until(proxyCondition);
    }

    public <T> T until(Callable<T> supplier, Matcher<? super T> matcher) {
        return this.until(new CallableHamcrestCondition<T>(supplier, matcher, this.generateConditionSettings()));
    }

    public void until(Runnable supplier) {
        this.until(new AssertionCondition(supplier, this.generateConditionSettings()));
    }

    public Integer untilAtomic(final AtomicInteger atomic, Matcher<? super Integer> matcher) {
        return this.until(new CallableHamcrestCondition<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() {
                return atomic.get();
            }
        }, matcher, this.generateConditionSettings()));
    }

    public Long untilAtomic(final AtomicLong atomic, Matcher<? super Long> matcher) {
        return this.until(new CallableHamcrestCondition<Long>(new Callable<Long>(){

            @Override
            public Long call() {
                return atomic.get();
            }
        }, matcher, this.generateConditionSettings()));
    }

    public void untilAtomic(final AtomicBoolean atomic, Matcher<? super Boolean> matcher) {
        this.until(new CallableHamcrestCondition<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return atomic.get();
            }
        }, matcher, this.generateConditionSettings()));
    }

    public void untilTrue(AtomicBoolean atomic) {
        this.untilAtomic(atomic, (Matcher<? super Boolean>)Matchers.anyOf((Matcher)Matchers.is((Object)Boolean.TRUE), (Matcher)Matchers.is((Object)true)));
    }

    public void untilFalse(AtomicBoolean atomic) {
        this.untilAtomic(atomic, (Matcher<? super Boolean>)Matchers.anyOf((Matcher)Matchers.is((Object)Boolean.FALSE), (Matcher)Matchers.is((Object)false)));
    }

    public <V> V untilAtomic(final AtomicReference<V> atomic, Matcher<? super V> matcher) {
        return this.until(new CallableHamcrestCondition<V>(new Callable<V>(){

            @Override
            public V call() {
                return atomic.get();
            }
        }, matcher, this.generateConditionSettings()));
    }

    public void until(Callable<Boolean> conditionEvaluator) {
        this.until(new CallableCondition(conditionEvaluator, this.generateConditionSettings()));
    }

    private ConditionSettings generateConditionSettings() {
        Duration actualPollDelay = this.definePollDelay(this.pollDelay, this.pollInterval);
        if (actualPollDelay.isForever()) {
            throw new IllegalArgumentException("Cannot delay polling forever");
        }
        Duration timeout = this.timeoutConstraint.getMaxWaitTime();
        long timeoutInMS = timeout.getValueInMS();
        if (!timeout.isForever() && timeoutInMS <= actualPollDelay.getValueInMS()) {
            throw new IllegalStateException(String.format("Timeout (%s %s) must be greater than the poll delay (%s %s).", timeout.getValue(), timeout.getTimeUnitAsString(), actualPollDelay.getValue(), actualPollDelay.getTimeUnitAsString()));
        }
        if (!actualPollDelay.isForever() && !timeout.isForever() && timeoutInMS <= actualPollDelay.getValueInMS()) {
            throw new IllegalStateException(String.format("Timeout (%s %s) must be greater than the poll delay (%s %s).", timeout.getValue(), timeout.getTimeUnitAsString(), actualPollDelay.getValue(), actualPollDelay.getTimeUnitAsString()));
        }
        return new ConditionSettings(this.alias, this.catchUncaughtExceptions, this.timeoutConstraint, this.pollInterval, actualPollDelay, this.conditionEvaluationListener, this.exceptionsIgnorer);
    }

    private <T> T until(Condition<T> condition) {
        return condition.await();
    }

    Duration definePollDelay(Duration pollDelay, PollInterval pollInterval) {
        Duration pollDelayToUse = pollDelay == null ? (pollInterval != null && pollInterval instanceof FixedPollInterval ? pollInterval.next(1, Duration.ZERO) : Duration.ZERO) : pollDelay;
        return pollDelayToUse;
    }

    static class MethodCaller<T>
    implements Callable<T> {
        final Object target;
        final Method method;
        final Object[] args;

        public MethodCaller(Object target, Method method, Object[] args) {
            this.target = target;
            this.method = method;
            this.args = args;
            method.setAccessible(true);
        }

        @Override
        public T call() {
            try {
                return (T)this.method.invoke(this.target, this.args);
            }
            catch (IllegalAccessException e) {
                return CheckedExceptionRethrower.safeRethrow(e);
            }
            catch (InvocationTargetException e) {
                return CheckedExceptionRethrower.safeRethrow(e.getCause());
            }
        }
    }
}

