/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.core;

import java.beans.Introspector;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.awaitility.Duration;
import org.awaitility.classpath.ClassPathResolver;
import org.awaitility.core.CheckedExceptionRethrower;
import org.awaitility.core.ConditionEvaluationHandler;
import org.awaitility.core.ConditionEvaluationResult;
import org.awaitility.core.ConditionEvaluator;
import org.awaitility.core.ConditionSettings;
import org.awaitility.core.ConditionTimeoutException;
import org.awaitility.core.DeadlockException;

abstract class ConditionAwaiter
implements Thread.UncaughtExceptionHandler {
    private final ExecutorService executor;
    private final ConditionEvaluator conditionEvaluator;
    private final AtomicReference<Throwable> uncaughtThrowable;
    private final ConditionSettings conditionSettings;

    ConditionAwaiter(ConditionEvaluator conditionEvaluator, ConditionSettings conditionSettings) {
        if (conditionEvaluator == null) {
            throw new IllegalArgumentException("You must specify a condition (was null).");
        }
        if (conditionSettings == null) {
            throw new IllegalArgumentException("You must specify the condition settings (was null).");
        }
        if (conditionSettings.shouldCatchUncaughtExceptions()) {
            Thread.setDefaultUncaughtExceptionHandler(this);
        }
        this.conditionSettings = conditionSettings;
        this.conditionEvaluator = conditionEvaluator;
        this.executor = conditionSettings.getPollExecutorService();
        this.uncaughtThrowable = new AtomicReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void await(ConditionEvaluationHandler<T> conditionEvaluationHandler) {
        Duration pollDelay = this.conditionSettings.getPollDelay();
        Duration maxWaitTime = this.conditionSettings.getMaxWaitTime();
        Duration minWaitTime = this.conditionSettings.getMinWaitTime();
        long maxTimeout = maxWaitTime.getValue();
        TimeUnit maxTimeoutUnit = maxWaitTime.getTimeUnit();
        long pollingStarted = System.currentTimeMillis() - pollDelay.getValueInMS();
        int pollCount = 0;
        boolean succeededBeforeTimeout = false;
        ConditionEvaluationResult lastResult = null;
        Duration evaluationDuration = new Duration(0L, TimeUnit.MILLISECONDS);
        try {
            conditionEvaluationHandler.start();
            if (!pollDelay.isZero()) {
                Thread.sleep(pollDelay.getValueInMS());
            }
            Duration pollInterval = pollDelay;
            while (!this.executor.isShutdown() && maxWaitTime.compareTo(evaluationDuration) > 0) {
                ++pollCount;
                lastResult = this.executor.submit(new ConditionPoller(pollInterval)).get(maxTimeout, maxTimeoutUnit);
                if (lastResult.isSuccessful() || lastResult.hasThrowable()) break;
                pollInterval = this.conditionSettings.getPollInterval().next(pollCount, pollInterval);
                Thread.sleep(pollInterval.getValueInMS());
                evaluationDuration = this.calculateConditionEvaluationDuration(pollDelay, pollingStarted);
            }
            succeededBeforeTimeout = maxWaitTime.compareTo(evaluationDuration = this.calculateConditionEvaluationDuration(pollDelay, pollingStarted)) > 0;
        }
        catch (Throwable e1) {
            Throwable throwable = e1 instanceof ExecutionException ? e1.getCause() : e1;
            lastResult = new ConditionEvaluationResult(false, throwable, null);
        }
        try {
            if (this.uncaughtThrowable.get() != null) {
                throw this.uncaughtThrowable.get();
            }
            if (lastResult != null && lastResult.hasThrowable()) {
                throw lastResult.getThrowable();
            }
            if (!succeededBeforeTimeout) {
                Throwable cause;
                String maxWaitTimeLowerCase = maxWaitTime.getTimeUnitAsString();
                String message = this.conditionSettings.hasAlias() ? String.format("Condition with alias '%s' didn't complete within %s %s because %s.", this.conditionSettings.getAlias(), maxTimeout, maxWaitTimeLowerCase, Introspector.decapitalize(this.getTimeoutMessage())) : String.format("%s within %s %s.", this.getTimeoutMessage(), maxTimeout, maxWaitTimeLowerCase);
                Throwable throwable = cause = lastResult != null && lastResult.hasTrace() ? lastResult.getTrace() : null;
                if (ClassPathResolver.existInCP("java.lang.management.ThreadMXBean") && ClassPathResolver.existInCP("java.lang.management.ManagementFactory")) {
                    ThreadMXBean bean = ManagementFactory.getThreadMXBean();
                    try {
                        long[] threadIds = bean.findDeadlockedThreads();
                        if (threadIds != null) {
                            cause = new DeadlockException(threadIds);
                        }
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
                throw new ConditionTimeoutException(message, cause);
            }
            if (evaluationDuration.compareTo(minWaitTime) < 0) {
                String message = String.format("Condition was evaluated in %s %s which is earlier than expected minimum timeout %s %s", new Object[]{evaluationDuration.getValue(), evaluationDuration.getTimeUnit(), minWaitTime.getValue(), minWaitTime.getTimeUnit()});
                throw new ConditionTimeoutException(message);
            }
        }
        catch (Throwable e) {
            CheckedExceptionRethrower.safeRethrow(e);
        }
        finally {
            this.uncaughtThrowable.set(null);
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    this.executor.shutdownNow();
                    this.executor.awaitTermination(1L, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException e) {
                CheckedExceptionRethrower.safeRethrow(e);
            }
        }
    }

    protected abstract String getTimeoutMessage();

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        if (!this.conditionSettings.shouldExceptionBeIgnored(throwable)) {
            this.uncaughtThrowable.set(throwable);
            this.executor.shutdownNow();
        }
    }

    private Duration calculateConditionEvaluationDuration(Duration pollDelay, long pollingStarted) {
        return new Duration(System.currentTimeMillis() - pollingStarted, TimeUnit.MILLISECONDS).minus(pollDelay);
    }

    private class ConditionPoller
    implements Callable<ConditionEvaluationResult> {
        private final Duration delayed;

        ConditionPoller(Duration delayed) {
            this.delayed = delayed;
        }

        @Override
        public ConditionEvaluationResult call() throws Exception {
            try {
                return ConditionAwaiter.this.conditionEvaluator.eval(this.delayed);
            }
            catch (Throwable e) {
                if (ConditionAwaiter.this.conditionSettings.shouldExceptionBeIgnored(e)) {
                    return new ConditionEvaluationResult(false);
                }
                return new ConditionEvaluationResult(false, e, null);
            }
        }
    }
}

