/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.core;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.awaitility.Duration;
import org.awaitility.classpath.ClassPathResolver;
import org.awaitility.constraint.AtMostWaitConstraint;
import org.awaitility.constraint.WaitConstraint;
import org.awaitility.core.AssertionCondition;
import org.awaitility.core.BiFunction;
import org.awaitility.core.CallableCondition;
import org.awaitility.core.CallableHamcrestCondition;
import org.awaitility.core.Condition;
import org.awaitility.core.ConditionEvaluationListener;
import org.awaitility.core.ConditionSettings;
import org.awaitility.core.ExceptionIgnorer;
import org.awaitility.core.Function;
import org.awaitility.core.HamcrestExceptionIgnorer;
import org.awaitility.core.InternalExecutorServiceFactory;
import org.awaitility.core.Predicate;
import org.awaitility.core.PredicateExceptionIgnorer;
import org.awaitility.core.ThrowingRunnable;
import org.awaitility.pollinterval.FixedPollInterval;
import org.awaitility.pollinterval.PollInterval;
import org.awaitility.spi.ProxyConditionFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class ConditionFactory {
    private final WaitConstraint timeoutConstraint;
    private final PollInterval pollInterval;
    private final boolean catchUncaughtExceptions;
    private final ExceptionIgnorer exceptionsIgnorer;
    private final String alias;
    private final Duration pollDelay;
    private final ConditionEvaluationListener conditionEvaluationListener;
    private final ExecutorService pollExecutorService;

    public ConditionFactory(String alias, WaitConstraint timeoutConstraint, PollInterval pollInterval, Duration pollDelay, boolean catchUncaughtExceptions, ExceptionIgnorer exceptionsIgnorer, ConditionEvaluationListener conditionEvaluationListener, ExecutorService pollExecutorService) {
        if (pollInterval == null) {
            throw new IllegalArgumentException("pollInterval cannot be null");
        }
        if (timeoutConstraint == null) {
            throw new IllegalArgumentException("timeout cannot be null");
        }
        this.alias = alias;
        this.timeoutConstraint = timeoutConstraint;
        this.pollInterval = pollInterval;
        this.catchUncaughtExceptions = catchUncaughtExceptions;
        this.pollDelay = pollDelay;
        this.conditionEvaluationListener = conditionEvaluationListener;
        this.exceptionsIgnorer = exceptionsIgnorer;
        this.pollExecutorService = pollExecutorService;
    }

    public ConditionFactory conditionEvaluationListener(ConditionEvaluationListener conditionEvaluationListener) {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, conditionEvaluationListener, this.pollExecutorService);
    }

    public ConditionFactory timeout(Duration timeout) {
        return this.atMost(timeout);
    }

    public ConditionFactory atMost(Duration timeout) {
        return new ConditionFactory(this.alias, this.timeoutConstraint.withMaxWaitTime(timeout), this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.pollExecutorService);
    }

    public ConditionFactory atLeast(Duration timeout) {
        return new ConditionFactory(this.alias, this.timeoutConstraint.withMinWaitTime(timeout), this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.pollExecutorService);
    }

    public ConditionFactory atLeast(long timeout, TimeUnit unit) {
        return this.atLeast(new Duration(timeout, unit));
    }

    public ConditionFactory between(Duration atLeast, Duration atMost) {
        return this.atLeast(atLeast).and().atMost(atMost);
    }

    public ConditionFactory between(long atLeastDuration, TimeUnit atLeastTimeUnit, long atMostDuration, TimeUnit atMostTimeUnit) {
        return this.between(new Duration(atLeastDuration, atLeastTimeUnit), new Duration(atMostDuration, atMostTimeUnit));
    }

    public ConditionFactory forever() {
        return new ConditionFactory(this.alias, AtMostWaitConstraint.FOREVER, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.pollExecutorService);
    }

    public ConditionFactory pollInterval(Duration pollInterval) {
        return new ConditionFactory(this.alias, this.timeoutConstraint, new FixedPollInterval(pollInterval), this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.pollExecutorService);
    }

    public ConditionFactory timeout(long timeout, TimeUnit unit) {
        return this.atMost(timeout, unit);
    }

    public ConditionFactory pollDelay(long delay, TimeUnit unit) {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, new Duration(delay, unit), this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.pollExecutorService);
    }

    public ConditionFactory pollDelay(Duration pollDelay) {
        if (pollDelay == null) {
            throw new IllegalArgumentException("pollDelay cannot be null");
        }
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.pollExecutorService);
    }

    public ConditionFactory atMost(long timeout, TimeUnit unit) {
        return this.atMost(new Duration(timeout, unit));
    }

    public ConditionFactory pollInterval(long pollInterval, TimeUnit unit) {
        FixedPollInterval fixedPollInterval = new FixedPollInterval(new Duration(pollInterval, unit));
        return new ConditionFactory(this.alias, this.timeoutConstraint, fixedPollInterval, this.definePollDelay(this.pollDelay, fixedPollInterval), this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.pollExecutorService);
    }

    public ConditionFactory pollInterval(PollInterval pollInterval) {
        return new ConditionFactory(this.alias, this.timeoutConstraint, pollInterval, this.definePollDelay(this.pollDelay, pollInterval), this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.pollExecutorService);
    }

    public ConditionFactory catchUncaughtExceptions() {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, true, this.exceptionsIgnorer, this.conditionEvaluationListener, this.pollExecutorService);
    }

    public ConditionFactory ignoreExceptionsInstanceOf(final Class<? extends Throwable> exceptionType) {
        if (exceptionType == null) {
            throw new IllegalArgumentException("exceptionType cannot be null");
        }
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, new PredicateExceptionIgnorer((Predicate<? super Throwable>)new Predicate<Throwable>(){

            @Override
            public boolean matches(Throwable e) {
                return exceptionType.isAssignableFrom(e.getClass());
            }
        }), this.conditionEvaluationListener, this.pollExecutorService);
    }

    public ConditionFactory ignoreException(final Class<? extends Throwable> exceptionType) {
        if (exceptionType == null) {
            throw new IllegalArgumentException("exception cannot be null");
        }
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, new PredicateExceptionIgnorer((Predicate<? super Throwable>)new Predicate<Throwable>(){

            @Override
            public boolean matches(Throwable e) {
                return e.getClass().equals(exceptionType);
            }
        }), this.conditionEvaluationListener, this.pollExecutorService);
    }

    public ConditionFactory ignoreExceptions() {
        return this.ignoreExceptionsMatching((Predicate<? super Throwable>)new Predicate<Throwable>(){

            @Override
            public boolean matches(Throwable e) {
                return true;
            }
        });
    }

    public ConditionFactory ignoreNoExceptions() {
        return this.ignoreExceptionsMatching((Predicate<? super Throwable>)new Predicate<Throwable>(){

            @Override
            public boolean matches(Throwable e) {
                return false;
            }
        });
    }

    public ConditionFactory ignoreExceptionsMatching(Matcher<? super Throwable> matcher) {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, new HamcrestExceptionIgnorer(matcher), this.conditionEvaluationListener, this.pollExecutorService);
    }

    public ConditionFactory ignoreExceptionsMatching(Predicate<? super Throwable> predicate) {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, new PredicateExceptionIgnorer(predicate), this.conditionEvaluationListener, this.pollExecutorService);
    }

    public ConditionFactory await() {
        return this;
    }

    public ConditionFactory await(String alias) {
        return new ConditionFactory(alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.pollExecutorService);
    }

    public ConditionFactory and() {
        return this;
    }

    public ConditionFactory with() {
        return this;
    }

    public ConditionFactory then() {
        return this;
    }

    public ConditionFactory given() {
        return this;
    }

    public ConditionFactory dontCatchUncaughtExceptions() {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, false, this.exceptionsIgnorer, this.conditionEvaluationListener, this.pollExecutorService);
    }

    public ConditionFactory pollExecutorService(ExecutorService executorService) {
        if (executorService != null && executorService instanceof ScheduledExecutorService) {
            throw new IllegalArgumentException("Poll executor service cannot be an instance of " + ScheduledExecutorService.class.getName());
        }
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, false, this.exceptionsIgnorer, this.conditionEvaluationListener, executorService);
    }

    public ConditionFactory pollThread(Function<Runnable, Thread> threadSupplier) {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, false, this.exceptionsIgnorer, this.conditionEvaluationListener, InternalExecutorServiceFactory.create(threadSupplier));
    }

    public ConditionFactory pollInSameThread() {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, false, this.exceptionsIgnorer, this.conditionEvaluationListener, InternalExecutorServiceFactory.sameThreadExecutorService());
    }

    public <T> T untilCall(T proxyMethodReturnValue, Matcher<? super T> matcher) {
        Iterator<ProxyConditionFactory> iterator;
        if (!ClassPathResolver.existInCP("java.util.ServiceLoader")) {
            throw new UnsupportedOperationException("java.util.ServiceLoader not found in classpath so cannot create condition");
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (!(iterator = ServiceLoader.load(ProxyConditionFactory.class, cl).iterator()).hasNext()) {
            throw new UnsupportedOperationException("There's currently no plugin installed that can handle proxy conditions, please consider adding 'awaitility-proxy' to the classpath. If using Maven you can do:<dependency>\n\t<groupId>org.awaitility</groupId>\n\t<artifactId>awaitility</artifactId>\n\t<version>${awaitility.version}</version>\n</dependency>\n");
        }
        ProxyConditionFactory factory = iterator.next();
        if (factory == null) {
            throw new IllegalArgumentException("Internal error: Proxy condition plugin initialization returned null, please report an issue.");
        }
        return this.until(factory.createProxyCondition(proxyMethodReturnValue, matcher, this.generateConditionSettings()));
    }

    public <T> T until(Callable<T> supplier, Matcher<? super T> matcher) {
        return this.until(new CallableHamcrestCondition<T>(supplier, matcher, this.generateConditionSettings()));
    }

    public void untilAsserted(ThrowingRunnable assertion) {
        this.until(new AssertionCondition(assertion, this.generateConditionSettings()));
    }

    public Integer untilAtomic(final AtomicInteger atomic, Matcher<? super Integer> matcher) {
        return this.until(new CallableHamcrestCondition<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() {
                return atomic.get();
            }
        }, matcher, this.generateConditionSettings()));
    }

    public Long untilAtomic(final AtomicLong atomic, Matcher<? super Long> matcher) {
        return this.until(new CallableHamcrestCondition<Long>(new Callable<Long>(){

            @Override
            public Long call() {
                return atomic.get();
            }
        }, matcher, this.generateConditionSettings()));
    }

    public void untilAtomic(final AtomicBoolean atomic, Matcher<? super Boolean> matcher) {
        this.until(new CallableHamcrestCondition<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return atomic.get();
            }
        }, matcher, this.generateConditionSettings()));
    }

    public void untilTrue(AtomicBoolean atomic) {
        this.untilAtomic(atomic, (Matcher<? super Boolean>)Matchers.anyOf((Matcher)Matchers.is((Object)Boolean.TRUE), (Matcher)Matchers.is((Object)true)));
    }

    public void untilFalse(AtomicBoolean atomic) {
        this.untilAtomic(atomic, (Matcher<? super Boolean>)Matchers.anyOf((Matcher)Matchers.is((Object)Boolean.FALSE), (Matcher)Matchers.is((Object)false)));
    }

    public <V> V untilAtomic(final AtomicReference<V> atomic, Matcher<? super V> matcher) {
        return this.until(new CallableHamcrestCondition<V>(new Callable<V>(){

            @Override
            public V call() {
                return atomic.get();
            }
        }, matcher, this.generateConditionSettings()));
    }

    public void until(Callable<Boolean> conditionEvaluator) {
        this.until(new CallableCondition(conditionEvaluator, this.generateConditionSettings()));
    }

    private ConditionSettings generateConditionSettings() {
        Duration actualPollDelay = this.definePollDelay(this.pollDelay, this.pollInterval);
        if (actualPollDelay.isForever()) {
            throw new IllegalArgumentException("Cannot delay polling forever");
        }
        Duration timeout = this.timeoutConstraint.getMaxWaitTime();
        long timeoutInMS = timeout.getValueInMS();
        if (!timeout.isForever() && timeoutInMS <= actualPollDelay.getValueInMS()) {
            throw new IllegalStateException(String.format("Timeout (%s %s) must be greater than the poll delay (%s %s).", timeout.getValue(), timeout.getTimeUnitAsString(), actualPollDelay.getValue(), actualPollDelay.getTimeUnitAsString()));
        }
        if (!actualPollDelay.isForever() && !timeout.isForever() && timeoutInMS <= actualPollDelay.getValueInMS()) {
            throw new IllegalStateException(String.format("Timeout (%s %s) must be greater than the poll delay (%s %s).", timeout.getValue(), timeout.getTimeUnitAsString(), actualPollDelay.getValue(), actualPollDelay.getTimeUnitAsString()));
        }
        ExecutorService executorService = this.pollExecutorService == null ? InternalExecutorServiceFactory.create(new BiFunction<Runnable, String, Thread>(){

            @Override
            public Thread apply(Runnable r, String threadName) {
                return new Thread(Thread.currentThread().getThreadGroup(), r, threadName);
            }
        }, this.alias) : this.pollExecutorService;
        return new ConditionSettings(this.alias, this.catchUncaughtExceptions, this.timeoutConstraint, this.pollInterval, actualPollDelay, this.conditionEvaluationListener, this.exceptionsIgnorer, executorService);
    }

    private <T> T until(Condition<T> condition) {
        return condition.await();
    }

    private Duration definePollDelay(Duration pollDelay, PollInterval pollInterval) {
        Duration pollDelayToUse = pollDelay == null ? (pollInterval != null && pollInterval instanceof FixedPollInterval ? pollInterval.next(1, Duration.ZERO) : Duration.ZERO) : pollDelay;
        return pollDelayToUse;
    }
}

