/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.util.StringTokenizer;
import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeGroup;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaContext;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;

public class WildcardUnmarshaller
extends ComponentReader {
    private static final String MAX_OCCURS_WILDCARD = "unbounded";
    private ComponentReader unmarshaller;
    private int depth = 0;
    private Wildcard _wildcard = null;
    private Schema _schema = null;
    private String _element = "any";

    public WildcardUnmarshaller(SchemaContext schemaContext, ComplexType complexType, Schema schema, String element, AttributeSet atts) {
        this(schemaContext, schema, element, atts, new Wildcard(complexType));
    }

    public WildcardUnmarshaller(SchemaContext schemaContext, Group group, Schema schema, String element, AttributeSet atts) {
        this(schemaContext, schema, element, atts, new Wildcard(group));
    }

    public WildcardUnmarshaller(SchemaContext schemaContext, AttributeGroup attGroup, Schema schema, String element, AttributeSet atts) {
        this(schemaContext, schema, element, atts, new Wildcard(attGroup));
    }

    private WildcardUnmarshaller(SchemaContext schemaContext, Schema schema, String element, AttributeSet atts, Wildcard wildcard) {
        super(schemaContext);
        this._wildcard = wildcard;
        this._schema = schema;
        this._element = element;
        String attValue = null;
        if ("anyAttribute".equals(element)) {
            this._wildcard.setAttributeWildcard();
        }
        this._element = element;
        attValue = atts.getValue("namespace");
        if (attValue != null) {
            StringTokenizer tokenizer = new StringTokenizer(attValue);
            while (tokenizer.hasMoreTokens()) {
                String temp = tokenizer.nextToken();
                if (tokenizer.countTokens() > 1 && ("##any".equals(temp) || "##other".equals(temp))) {
                    throw new IllegalArgumentException(temp + " is not valid when multiple namespaces are listed.");
                }
                if (SchemaNames.isNamespaceName(temp)) {
                    this._wildcard.addNamespace(temp);
                    continue;
                }
                String err = "Invalid 'namespace' value: " + temp;
                throw new IllegalArgumentException(err);
            }
        } else {
            this._wildcard.addNamespace("##any");
        }
        attValue = atts.getValue("maxOccurs");
        if (attValue != null) {
            if (this._wildcard.isAttributeWildcard()) {
                throw new IllegalStateException("'maxOccurs' is prohibited on a <anyAttribute> element.");
            }
            if (MAX_OCCURS_WILDCARD.equals(attValue)) {
                attValue = "-1";
            }
            int maxOccurs = WildcardUnmarshaller.toInt(attValue);
            this._wildcard.setMaxOccurs(maxOccurs);
        }
        if ((attValue = atts.getValue("minOccurs")) != null) {
            if (this._wildcard.isAttributeWildcard()) {
                throw new IllegalStateException("'minOccurs' is prohibited on a <anyAttribute> element.");
            }
            this._wildcard.setMinOccurs(WildcardUnmarshaller.toInt(attValue));
        }
        if ((attValue = atts.getValue("processContents")) != null) {
            try {
                this._wildcard.setProcessContents(attValue);
            }
            catch (SchemaException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        this._wildcard.setId(atts.getValue("id"));
    }

    @Override
    public String elementName() {
        return this._element;
    }

    public Wildcard getWildcard() {
        return this._wildcard;
    }

    @Override
    public Object getObject() {
        return this.getWildcard();
    }

    @Override
    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(name, namespace, atts, nsDecls);
            ++this.depth;
            return;
        }
        if (!"annotation".equals(name)) {
            String err = new StringBuffer("illegal element <").append(name).append("> found in <").append(this._element).append('>').toString();
            throw new SchemaException(err);
        }
        this.unmarshaller = new AnnotationUnmarshaller(this.getSchemaContext(), atts);
    }

    @Override
    public void endElement(String name, String namespace) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(name, namespace);
            --this.depth;
            return;
        }
        if (this.unmarshaller != null && !name.equals(this.unmarshaller.elementName())) {
            String err = "missing end element for ";
            err = err + this.unmarshaller.elementName();
            throw new SchemaException(err);
        }
        this.unmarshaller.finish();
        if (name == "annotation") {
            this._schema.addAnnotation((Annotation)this.unmarshaller.getObject());
        }
        this.unmarshaller = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(ch, start, length);
        }
    }
}

