/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class RegexPropertyMojo
extends AbstractMojo {
    private MavenProject project;
    private String name;
    private String value;
    private String regex;
    private String replacement;
    private boolean failIfNoMatch;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Pattern pattern;
        try {
            pattern = Pattern.compile(this.regex);
        }
        catch (PatternSyntaxException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        Matcher matcher = pattern.matcher(this.value);
        if (!matcher.find()) {
            if (this.failIfNoMatch) {
                throw new MojoFailureException("No match to regex '" + this.regex + "' found in '" + this.value + "'.");
            }
            this.getLog().info((CharSequence)("No match to regex '" + this.regex + "' found in '" + this.value + "'."));
        } else {
            this.value = matcher.replaceAll(this.replacement);
        }
        this.getLog().info((CharSequence)("Setting property '" + this.name + "' to '" + this.value + "'."));
        this.project.getProperties().setProperty(this.name, this.value);
    }
}

