/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import org.dbunit.IDatabaseTester;
import org.dbunit.assertion.DefaultFailureHandler;
import org.dbunit.assertion.SimpleAssert;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseTester
extends SimpleAssert
implements IDatabaseTester {
    private static final Logger logger = LoggerFactory.getLogger((Class)AbstractDatabaseTester.class);
    private IDataSet dataSet;
    private String schema;
    private DatabaseOperation setUpOperation = DatabaseOperation.CLEAN_INSERT;
    private DatabaseOperation tearDownOperation = DatabaseOperation.NONE;

    public AbstractDatabaseTester() {
        this((String)null);
    }

    public AbstractDatabaseTester(String schema) {
        super(new DefaultFailureHandler());
        this.schema = schema;
    }

    public void closeConnection(IDatabaseConnection connection) throws Exception {
        logger.debug("closeConnection(connection={}) - start", (Object)connection);
        connection.close();
    }

    public IDataSet getDataSet() {
        logger.debug("getDataSet() - start");
        return this.dataSet;
    }

    public void onSetup() throws Exception {
        logger.debug("onSetup() - start");
        this.executeOperation(this.getSetUpOperation());
    }

    public void onTearDown() throws Exception {
        logger.debug("onTearDown() - start");
        this.executeOperation(this.getTearDownOperation());
    }

    public void setDataSet(IDataSet dataSet) {
        logger.debug("setDataSet(dataSet={}) - start", (Object)dataSet);
        this.dataSet = dataSet;
    }

    public void setSchema(String schema) {
        logger.debug("setSchema(schema={}) - start", (Object)schema);
        logger.warn("setSchema() should not be used anymore");
        this.schema = schema;
    }

    public void setSetUpOperation(DatabaseOperation setUpOperation) {
        logger.debug("setSetUpOperation(setUpOperation={}) - start", (Object)setUpOperation);
        this.setUpOperation = setUpOperation;
    }

    public void setTearDownOperation(DatabaseOperation tearDownOperation) {
        logger.debug("setTearDownOperation(tearDownOperation={}) - start", (Object)tearDownOperation);
        this.tearDownOperation = tearDownOperation;
    }

    protected String getSchema() {
        logger.trace("getSchema() - start");
        return this.schema;
    }

    protected DatabaseOperation getSetUpOperation() {
        logger.trace("getSetUpOperation() - start");
        return this.setUpOperation;
    }

    protected DatabaseOperation getTearDownOperation() {
        logger.trace("getTearDownOperation() - start");
        return this.tearDownOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeOperation(DatabaseOperation operation) throws Exception {
        logger.debug("executeOperation(operation={}) - start", (Object)operation);
        if (operation != DatabaseOperation.NONE) {
            IDatabaseConnection connection = this.getConnection();
            try {
                operation.execute(connection, this.getDataSet());
            }
            finally {
                this.closeConnection(connection);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append("schema=").append(this.schema);
        sb.append(", dataSet=").append(this.dataSet);
        sb.append(", setUpOperation=").append(this.setUpOperation);
        sb.append(", tearDownOperation=").append(this.tearDownOperation);
        sb.append("]");
        return sb.toString();
    }
}

