/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import junit.framework.TestCase;
import org.dbunit.DefaultDatabaseTester;
import org.dbunit.IDatabaseTester;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseTestCase
extends TestCase {
    private static final Logger logger = LoggerFactory.getLogger((Class)DatabaseTestCase.class);
    private IDatabaseTester tester;

    public DatabaseTestCase() {
    }

    public DatabaseTestCase(String name) {
        super(name);
    }

    protected abstract IDatabaseConnection getConnection() throws Exception;

    protected abstract IDataSet getDataSet() throws Exception;

    protected IDatabaseTester newDatabaseTester() throws Exception {
        logger.debug("newDatabaseTester() - start");
        IDatabaseConnection connection = this.getConnection();
        this.setUpDatabaseConfig(connection.getConfig());
        DefaultDatabaseTester tester = new DefaultDatabaseTester(connection);
        return tester;
    }

    protected void setUpDatabaseConfig(DatabaseConfig config) {
    }

    protected IDatabaseTester getDatabaseTester() throws Exception {
        if (this.tester == null) {
            this.tester = this.newDatabaseTester();
        }
        return this.tester;
    }

    protected void closeConnection(IDatabaseConnection connection) throws Exception {
        logger.debug("closeConnection(connection={}) - start", (Object)connection);
        DatabaseTestCase.assertNotNull((String)"DatabaseTester is not set", (Object)this.getDatabaseTester());
        this.getDatabaseTester().closeConnection(connection);
    }

    protected DatabaseOperation getSetUpOperation() throws Exception {
        return DatabaseOperation.CLEAN_INSERT;
    }

    protected DatabaseOperation getTearDownOperation() throws Exception {
        return DatabaseOperation.NONE;
    }

    protected void setUp() throws Exception {
        logger.debug("setUp() - start");
        super.setUp();
        IDatabaseTester databaseTester = this.getDatabaseTester();
        DatabaseTestCase.assertNotNull((String)"DatabaseTester is not set", (Object)databaseTester);
        databaseTester.setSetUpOperation(this.getSetUpOperation());
        databaseTester.setDataSet(this.getDataSet());
        databaseTester.onSetup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        logger.debug("tearDown() - start");
        try {
            IDatabaseTester databaseTester = this.getDatabaseTester();
            DatabaseTestCase.assertNotNull((String)"DatabaseTester is not set", (Object)databaseTester);
            databaseTester.setTearDownOperation(this.getTearDownOperation());
            databaseTester.setDataSet(this.getDataSet());
            databaseTester.onTearDown();
        }
        finally {
            this.tester = null;
            super.tearDown();
        }
    }
}

