/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.common.handlers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.dbunit.dataset.common.handlers.Handler;
import org.dbunit.dataset.common.handlers.IllegalInputCharacterException;
import org.dbunit.dataset.common.handlers.NoHandler;
import org.dbunit.dataset.common.handlers.PipelineComponent;
import org.dbunit.dataset.common.handlers.PipelineConfig;
import org.dbunit.dataset.common.handlers.PipelineException;
import org.dbunit.dataset.common.handlers.TransparentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pipeline
implements Handler {
    private static final Logger logger = LoggerFactory.getLogger((Class)Pipeline.class);
    private LinkedList components;
    private List products;
    private StringBuffer currentProduct;
    private PipelineComponent noHandler;
    private PipelineConfig pipelineConfig = new PipelineConfig();

    public Pipeline() {
        this.setComponents(new LinkedList());
        this.setProducts(new ArrayList());
        this.setNoHandler(NoHandler.IGNORE());
        this.getNoHandler().setSuccessor(null);
        this.getComponents().addFirst(this.getNoHandler());
        this.setCurrentProduct(new StringBuffer());
        this.putFront(TransparentHandler.IGNORE());
    }

    public StringBuffer getCurrentProduct() {
        logger.debug("getCurrentProduct() - start");
        return this.currentProduct;
    }

    public void setCurrentProduct(StringBuffer currentProduct) {
        logger.debug("setCurrentProduct(currentProduct={}) - start", (Object)currentProduct);
        this.currentProduct = currentProduct;
    }

    private void prepareNewPiece() {
        logger.debug("prepareNewPiece() - start");
        this.setCurrentProduct(new StringBuffer());
        try {
            while (!(this.getComponents().getFirst() instanceof TransparentHandler)) {
                this.removeFront();
            }
        }
        catch (PipelineException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void thePieceIsDone() {
        logger.debug("thePieceIsDone() - start");
        this.getProducts().add(this.getCurrentProduct().toString());
        this.prepareNewPiece();
    }

    public List getProducts() {
        logger.debug("getProducts() - start");
        return this.products;
    }

    protected void setProducts(List products) {
        logger.debug("setProducts(products={}) - start", (Object)products);
        this.products = products;
    }

    private LinkedList getComponents() {
        logger.debug("getComponents() - start");
        return this.components;
    }

    private void setComponents(LinkedList components) {
        logger.debug("setComponents(components={}) - start", (Object)components);
        this.components = components;
    }

    public void putFront(PipelineComponent component) {
        logger.debug("putFront(component={}) - start", (Object)component);
        component.setSuccessor((PipelineComponent)this.getComponents().getFirst());
        component.setPipeline(this);
        this.getComponents().addFirst(component);
    }

    public PipelineComponent removeFront() throws PipelineException {
        logger.debug("removeFront() - start");
        PipelineComponent first = (PipelineComponent)this.getComponents().getFirst();
        this.remove(first);
        return first;
    }

    public void remove(PipelineComponent component) throws PipelineException {
        logger.debug("remove(component={}) - start", (Object)component);
        if (component == this.getNoHandler()) {
            throw new PipelineException("Cannot remove the last handler");
        }
        if (!this.getComponents().remove(component)) {
            throw new PipelineException("Cannot remove a non existent component from a pipeline");
        }
    }

    public boolean canHandle(char c) throws IllegalInputCharacterException {
        if (logger.isDebugEnabled()) {
            logger.debug("canHandle(c={}) - start", (Object)String.valueOf(c));
        }
        return true;
    }

    public void handle(char c) throws IllegalInputCharacterException, PipelineException {
        if (logger.isDebugEnabled()) {
            logger.debug("handle(c={}) - start", (Object)String.valueOf(c));
        }
        ((Handler)this.getComponents().getFirst()).handle(c);
    }

    public boolean allowForNoMoreInput() {
        logger.debug("allowForNoMoreInput() - start");
        throw new IllegalStateException("you cannot call Pipeline.allowForNoMoreInput");
    }

    private PipelineComponent getNoHandler() {
        logger.debug("getNoHandler() - start");
        return this.noHandler;
    }

    private void setNoHandler(PipelineComponent noHandler) {
        logger.debug("setNoHandler(noHandler={}) - start", (Object)noHandler);
        this.noHandler = noHandler;
    }

    public void resetProducts() {
        logger.debug("resetProducts() - start");
        this.setProducts(new ArrayList());
    }

    public void noMoreInput() {
        logger.debug("noMoreInput() - start");
        ((Handler)this.getComponents().getFirst()).noMoreInput();
    }

    public PipelineConfig getPipelineConfig() {
        return this.pipelineConfig;
    }

    public void setPipelineConfig(PipelineConfig pipelineConfig) {
        this.pipelineConfig = pipelineConfig;
    }
}

