/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.excel;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.dbunit.dataset.AbstractTable;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XlsTable
extends AbstractTable {
    private static final Logger logger = LoggerFactory.getLogger((Class)XlsTable.class);
    private final ITableMetaData _metaData;
    private final HSSFSheet _sheet;
    private final DecimalFormatSymbols symbols = new DecimalFormatSymbols();

    public XlsTable(String sheetName, HSSFSheet sheet) throws DataSetException {
        int rowCount = sheet.getLastRowNum();
        this._metaData = rowCount >= 0 && sheet.getRow(0) != null ? XlsTable.createMetaData(sheetName, sheet.getRow(0)) : new DefaultTableMetaData(sheetName, new Column[0]);
        this._sheet = sheet;
        this.symbols.setDecimalSeparator('.');
    }

    static ITableMetaData createMetaData(String tableName, HSSFRow sampleRow) {
        HSSFCell cell;
        logger.debug("createMetaData(tableName={}, sampleRow={}) - start", (Object)tableName, (Object)sampleRow);
        ArrayList<Column> columnList = new ArrayList<Column>();
        int i = 0;
        while ((cell = sampleRow.getCell(i)) != null) {
            String columnName = cell.getRichStringCellValue().getString();
            if (columnName != null) {
                columnName = columnName.trim();
            }
            Column column = new Column(columnName, DataType.UNKNOWN);
            columnList.add(column);
            ++i;
        }
        Column[] columns = columnList.toArray(new Column[0]);
        return new DefaultTableMetaData(tableName, columns);
    }

    public int getRowCount() {
        logger.debug("getRowCount() - start");
        return this._sheet.getLastRowNum();
    }

    public ITableMetaData getTableMetaData() {
        logger.debug("getTableMetaData() - start");
        return this._metaData;
    }

    public Object getValue(int row, String column) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("getValue(row={}, columnName={}) - start", (Object)Integer.toString(row), (Object)column);
        }
        this.assertValidRowIndex(row);
        int columnIndex = this.getColumnIndex(column);
        HSSFCell cell = this._sheet.getRow(row + 1).getCell(columnIndex);
        if (cell == null) {
            return null;
        }
        int type = cell.getCellType();
        switch (type) {
            case 0: {
                HSSFCellStyle style = cell.getCellStyle();
                if (HSSFDateUtil.isCellDateFormatted((HSSFCell)cell) || "####################".equals(style.getDataFormatString())) {
                    return this.getDateValue(cell);
                }
                return this.getNumericValue(cell);
            }
            case 1: {
                return cell.getRichStringCellValue().getString();
            }
            case 2: {
                throw new DataTypeException("Formula not supported at row=" + row + ", column=" + column);
            }
            case 3: {
                return null;
            }
            case 4: {
                return cell.getBooleanCellValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                throw new DataTypeException("Error at row=" + row + ", column=" + column);
            }
        }
        throw new DataTypeException("Unsupported type at row=" + row + ", column=" + column);
    }

    protected Object getDateValue(HSSFCell cell) {
        logger.debug("getDateValue(cell={}) - start", (Object)cell);
        double numericValue = cell.getNumericCellValue();
        BigDecimal numericValueBd = new BigDecimal(String.valueOf(numericValue));
        numericValueBd = this.stripTrailingZeros(numericValueBd);
        return new Long(numericValueBd.unscaledValue().longValue());
    }

    private BigDecimal stripTrailingZeros(BigDecimal value) {
        if (value.scale() <= 0) {
            return value;
        }
        String valueAsString = String.valueOf(value);
        int idx = valueAsString.indexOf(".");
        if (idx == -1) {
            return value;
        }
        for (int i = valueAsString.length() - 1; i > idx; --i) {
            if (valueAsString.charAt(i) != '0') {
                if (valueAsString.charAt(i) != '.') break;
                valueAsString = valueAsString.substring(0, i);
                break;
            }
            valueAsString = valueAsString.substring(0, i);
        }
        BigDecimal result = new BigDecimal(valueAsString);
        return result;
    }

    protected BigDecimal getNumericValue(HSSFCell cell) {
        BigDecimal result;
        logger.debug("getNumericValue(cell={}) - start", (Object)cell);
        String formatString = cell.getCellStyle().getDataFormatString();
        String resultString = null;
        double cellValue = cell.getNumericCellValue();
        if (formatString != null && !formatString.equals("General") && !formatString.equals("@")) {
            logger.debug("formatString={}", (Object)formatString);
            DecimalFormat nf = new DecimalFormat(formatString, this.symbols);
            resultString = nf.format(cellValue);
        }
        if (resultString != null) {
            try {
                result = new BigDecimal(resultString);
            }
            catch (NumberFormatException e) {
                logger.debug("Exception occurred while trying create a BigDecimal. value={}", resultString);
                result = new BigDecimal(String.valueOf(cellValue));
            }
        } else {
            result = new BigDecimal(String.valueOf(cellValue));
        }
        return result;
    }
}

