/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.oracle;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.BlobDataType;
import org.dbunit.dataset.datatype.TypeCastException;

public class OracleXMLTypeDataType
extends BlobDataType {
    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        Object data = new byte[]{};
        try {
            ClassLoader classLoader = resultSet.getClass().getClassLoader();
            Class cOracleResultSet = super.loadClass("oracle.jdbc.OracleResultSet", classLoader);
            Class cOPAQUE = super.loadClass("oracle.sql.OPAQUE", classLoader);
            Method mGetOPAQUE = cOracleResultSet.getMethod("getOPAQUE", Integer.TYPE);
            Method mGetBytes = cOPAQUE.getMethod("getBytes", null);
            ResultSet ors = resultSet;
            Object opaque = mGetOPAQUE.invoke((Object)ors, new Integer(column));
            if (opaque != null) {
                data = mGetBytes.invoke(opaque, null);
            }
        }
        catch (SecurityException e) {
            throw new TypeCastException(data, this, e);
        }
        catch (IllegalArgumentException e) {
            throw new TypeCastException(data, this, e);
        }
        catch (ClassNotFoundException e) {
            throw new TypeCastException(data, this, e);
        }
        catch (NoSuchMethodException e) {
            throw new TypeCastException(data, this, e);
        }
        catch (IllegalAccessException e) {
            throw new TypeCastException(data, this, e);
        }
        catch (InvocationTargetException e) {
            throw new TypeCastException(data, this, e);
        }
        return this.typeCast(data);
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        try {
            ClassLoader classLoader = statement.getClass().getClassLoader();
            Class cOraclePreparedStatement = super.loadClass("oracle.jdbc.OraclePreparedStatement", classLoader);
            Class cOpaqueDescriptor = super.loadClass("oracle.sql.OpaqueDescriptor", classLoader);
            Class cOPAQUE = super.loadClass("oracle.sql.OPAQUE", classLoader);
            Constructor mOPAQUEConstructor = cOPAQUE.getConstructor(cOpaqueDescriptor, new byte[0].getClass(), Connection.class);
            Method mCreateDescriptor = cOpaqueDescriptor.getMethod("createDescriptor", String.class, Connection.class);
            Method mSetOPAQUE = cOraclePreparedStatement.getMethod("setOPAQUE", Integer.TYPE, cOPAQUE);
            PreparedStatement oraclePreparedStatement = statement;
            Object opaqueDescriptor = mCreateDescriptor.invoke(null, "SYS.XMLTYPE", statement.getConnection());
            Object opaque = mOPAQUEConstructor.newInstance(opaqueDescriptor, this.typeCast(value), statement.getConnection());
            mSetOPAQUE.invoke((Object)oraclePreparedStatement, new Integer(column), opaque);
        }
        catch (TypeCastException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (SecurityException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (IllegalArgumentException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (ClassNotFoundException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (NoSuchMethodException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (IllegalAccessException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (InvocationTargetException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (InstantiationException e) {
            throw new TypeCastException(value, this, e);
        }
    }
}

