/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLHelper {
    public static final String DB_PRODUCT_SYBASE = "Sybase";
    private static final Logger logger = LoggerFactory.getLogger((Class)SQLHelper.class);

    private SQLHelper() {
    }

    public static String getPrimaryKeyColumn(Connection conn, String table) throws SQLException {
        logger.debug("getPrimaryKeyColumn(conn={}, table={}) - start", (Object)conn, (Object)table);
        DatabaseMetaData metadata = conn.getMetaData();
        ResultSet rs = metadata.getPrimaryKeys(null, null, table);
        rs.next();
        String pkColumn = rs.getString(4);
        return pkColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(ResultSet rs, Statement stmt) throws SQLException {
        logger.debug("close(rs={}, stmt={}) - start", (Object)rs, (Object)stmt);
        try {
            SQLHelper.close(rs);
        }
        finally {
            SQLHelper.close(stmt);
        }
    }

    public static void close(Statement stmt) throws SQLException {
        logger.debug("close(stmt={}) - start", (Object)stmt);
        if (stmt != null) {
            stmt.close();
        }
    }

    public static void close(ResultSet resultSet) throws SQLException {
        logger.debug("close(resultSet={}) - start", (Object)resultSet);
        if (resultSet != null) {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean schemaExists(Connection connection, String schema) throws SQLException {
        logger.debug("schemaExists(connection={}, schema={}) - start", (Object)connection, (Object)schema);
        if (schema == null) {
            throw new NullPointerException("The parameter 'schema' must not be null");
        }
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet rs = metaData.getSchemas();
        try {
            while (rs.next()) {
                String foundSchema = rs.getString("TABLE_SCHEM");
                if (!foundSchema.equals(schema)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableExists(DatabaseMetaData metaData, String schema, String tableName) throws SQLException {
        ResultSet tableRs = metaData.getTables(null, schema, tableName, null);
        try {
            boolean bl = tableRs.next();
            return bl;
        }
        finally {
            SQLHelper.close(tableRs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printAllTables(DatabaseMetaData metaData, PrintStream outputStream) throws SQLException {
        ResultSet rs = metaData.getTables(null, null, null, null);
        try {
            while (rs.next()) {
                String catalog = rs.getString("TABLE_CAT");
                String schema = rs.getString("TABLE_SCHEM");
                String table = rs.getString("TABLE_NAME");
                StringBuffer tableInfo = new StringBuffer();
                if (catalog != null) {
                    tableInfo.append(catalog).append(".");
                }
                if (schema != null) {
                    tableInfo.append(schema).append(".");
                }
                tableInfo.append(table);
                outputStream.println(tableInfo);
            }
            outputStream.flush();
        }
        finally {
            SQLHelper.close(rs);
        }
    }

    public static String getDatabaseInfo(DatabaseMetaData metaData) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append("\tdatabase name=").append(metaData.getDatabaseProductName()).append("\n");
        sb.append("\tdatabase version=").append(metaData.getDatabaseProductVersion()).append("\n");
        sb.append("\tdatabase major version=").append(metaData.getDatabaseMajorVersion()).append("\n");
        sb.append("\tdatabase minor version=").append(metaData.getDatabaseMinorVersion()).append("\n");
        sb.append("\tjdbc driver name=").append(metaData.getDriverName()).append("\n");
        sb.append("\tjdbc driver version=").append(metaData.getDriverVersion()).append("\n");
        sb.append("\tjdbc driver major version=").append(metaData.getDriverMajorVersion()).append("\n");
        sb.append("\tjdbc driver minor version=").append(metaData.getDriverMinorVersion()).append("\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printDatabaseInfo(DatabaseMetaData metaData, PrintStream outputStream) throws SQLException {
        String dbInfo = SQLHelper.getDatabaseInfo(metaData);
        try {
            outputStream.println(dbInfo);
        }
        finally {
            outputStream.flush();
        }
    }

    public static boolean isSybaseDb(DatabaseMetaData metaData) throws SQLException {
        String dbProductName = metaData.getDatabaseProductName();
        boolean isSybase = dbProductName != null && dbProductName.equals(DB_PRODUCT_SYBASE);
        return isSybase;
    }

    public static final Column createColumn(ResultSet resultSet, IDataTypeFactory dataTypeFactory, boolean datatypeWarning) throws SQLException, DataTypeException {
        String isAutoIncrement;
        String columnDefaultValue;
        String remarks;
        int nullable;
        String sqlTypeName;
        int sqlType;
        String columnName;
        String tableName;
        block4: {
            tableName = resultSet.getString(3);
            columnName = resultSet.getString(4);
            sqlType = resultSet.getInt(5);
            sqlTypeName = resultSet.getString(6);
            nullable = resultSet.getInt(11);
            remarks = resultSet.getString(12);
            columnDefaultValue = resultSet.getString(13);
            isAutoIncrement = Column.AutoIncrement.NO.getKey();
            try {
                isAutoIncrement = resultSet.getString(23);
            }
            catch (SQLException e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("Could not retrieve the 'isAutoIncrement' property because not yet running on Java 1.5 - defaulting to NO. Table=" + tableName + ", Column=" + columnName, (Throwable)e);
            }
        }
        DataType dataType = dataTypeFactory.createDataType(sqlType, sqlTypeName, tableName, columnName);
        if (dataType != DataType.UNKNOWN) {
            Column column = new Column(columnName, dataType, sqlTypeName, Column.nullableValue(nullable), columnDefaultValue, remarks, Column.AutoIncrement.autoIncrementValue(isAutoIncrement));
            return column;
        }
        if (datatypeWarning) {
            logger.warn(tableName + "." + columnName + " data type (" + sqlType + ", '" + sqlTypeName + "') not recognized and will be ignored. See FAQ for more information.");
        }
        return null;
    }

    public static boolean matches(ResultSet resultSet, String schema, String table, boolean caseSensitive) throws SQLException {
        return SQLHelper.matches(resultSet, null, schema, table, null, caseSensitive);
    }

    public static boolean matches(ResultSet resultSet, String catalog, String schema, String table, String column, boolean caseSensitive) throws SQLException {
        String catalogName = resultSet.getString(1);
        String schemaName = resultSet.getString(2);
        String tableName = resultSet.getString(3);
        String columnName = resultSet.getString(4);
        if (schema != null && schemaName == null && catalog == null && catalogName != null) {
            logger.debug("Switching catalog/schema because the are mutually null");
            schemaName = catalogName;
            catalogName = null;
        }
        boolean areEqual = SQLHelper.areEqualIgnoreNull(catalog, catalogName, caseSensitive) && SQLHelper.areEqualIgnoreNull(schema, schemaName, caseSensitive) && SQLHelper.areEqualIgnoreNull(table, tableName, caseSensitive) && SQLHelper.areEqualIgnoreNull(column, columnName, caseSensitive);
        return areEqual;
    }

    private static boolean areEqualIgnoreNull(String value1, String value2, boolean caseSensitive) {
        if (value1 == null || value1.equals("")) {
            return true;
        }
        if (caseSensitive && value1.equals(value2)) {
            return true;
        }
        return !caseSensitive && value1.equalsIgnoreCase(value2);
    }
}

