/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigIntegerDataType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger((Class)BigIntegerDataType.class);

    public BigIntegerDataType() {
        super("BIGINT", -5, BigInteger.class, true);
    }

    public Object typeCast(Object value) throws TypeCastException {
        logger.debug("typeCast(value={}) - start", value);
        if (value == null || value == ITable.NO_VALUE) {
            return null;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (value instanceof Number) {
            long l = ((Number)value).longValue();
            return new BigInteger(String.valueOf(l));
        }
        try {
            BigDecimal bd = new BigDecimal(value.toString());
            return bd.toBigInteger();
        }
        catch (NumberFormatException e) {
            throw new TypeCastException(value, this, e);
        }
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        if (logger.isDebugEnabled()) {
            logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)new Integer(column), (Object)resultSet);
        }
        BigDecimal value = resultSet.getBigDecimal(column);
        if (resultSet.wasNull()) {
            return null;
        }
        return value.toBigInteger();
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        if (logger.isDebugEnabled()) {
            logger.debug("setSqlValue(value={}, column={}, statement={}) - start", new Object[]{value, new Integer(column), statement});
        }
        BigInteger val = (BigInteger)this.typeCast(value);
        statement.setBigDecimal(column, new BigDecimal(val));
    }
}

