/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.oracle;

import java.util.Arrays;
import java.util.Collection;
import org.dbunit.dataset.datatype.BinaryStreamDataType;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.dbunit.dataset.datatype.StringDataType;
import org.dbunit.ext.oracle.OracleBlobDataType;
import org.dbunit.ext.oracle.OracleClobDataType;
import org.dbunit.ext.oracle.OracleNClobDataType;
import org.dbunit.ext.oracle.OracleSdoGeometryDataType;
import org.dbunit.ext.oracle.OracleXMLTypeDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDataTypeFactory
extends DefaultDataTypeFactory {
    private static final Logger logger = LoggerFactory.getLogger((Class)OracleDataTypeFactory.class);
    private static final Collection DATABASE_PRODUCTS = Arrays.asList("oracle");
    public static final DataType ORACLE_BLOB = new OracleBlobDataType();
    public static final DataType ORACLE_CLOB = new OracleClobDataType();
    public static final DataType ORACLE_NCLOB = new OracleNClobDataType();
    public static final DataType ORACLE_XMLTYPE = new OracleXMLTypeDataType();
    public static final DataType ORACLE_SDO_GEOMETRY_TYPE = new OracleSdoGeometryDataType();
    public static final DataType LONG_RAW = new BinaryStreamDataType("LONG RAW", -4);
    public static final DataType ROWID_TYPE = new StringDataType("ROWID", 1111);

    public Collection getValidDbProducts() {
        return DATABASE_PRODUCTS;
    }

    public DataType createDataType(int sqlType, String sqlTypeName) throws DataTypeException {
        if (logger.isDebugEnabled()) {
            logger.debug("createDataType(sqlType={}, sqlTypeName={}) - start", (Object)String.valueOf(sqlType), (Object)sqlTypeName);
        }
        if (sqlType == 91) {
            return DataType.TIMESTAMP;
        }
        if (sqlTypeName.startsWith("TIMESTAMP")) {
            return DataType.TIMESTAMP;
        }
        if ("XMLTYPE".equals(sqlTypeName)) {
            return ORACLE_XMLTYPE;
        }
        if ("BLOB".equals(sqlTypeName)) {
            return ORACLE_BLOB;
        }
        if ("CLOB".equals(sqlTypeName)) {
            return ORACLE_CLOB;
        }
        if ("NCLOB".equals(sqlTypeName)) {
            return ORACLE_NCLOB;
        }
        if ("NVARCHAR2".equals(sqlTypeName)) {
            return DataType.VARCHAR;
        }
        if (sqlTypeName.startsWith("NCHAR")) {
            return DataType.CHAR;
        }
        if ("FLOAT".equals(sqlTypeName)) {
            return DataType.FLOAT;
        }
        if (LONG_RAW.toString().equals(sqlTypeName)) {
            return LONG_RAW;
        }
        if ("BINARY_DOUBLE".equals(sqlTypeName)) {
            return DataType.DOUBLE;
        }
        if ("BINARY_FLOAT".equals(sqlTypeName)) {
            return DataType.FLOAT;
        }
        if ("ROWID".equals(sqlTypeName)) {
            return ROWID_TYPE;
        }
        if ("SDO_GEOMETRY".equals(sqlTypeName) || "MDSYS.SDO_GEOMETRY".equals(sqlTypeName)) {
            return ORACLE_SDO_GEOMETRY_TYPE;
        }
        return super.createDataType(sqlType, sqlTypeName);
    }
}

