/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.oracle;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.text.ParseException;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleSdoGeometryDataType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger((Class)OracleSdoGeometryDataType.class);
    private static final String NULL = "NULL";
    private static final String SDO_GEOMETRY = "SDO_GEOMETRY";
    private static final String SDO_POINT_TYPE = "SDO_POINT_TYPE";
    private static final String SDO_ELEM_INFO_ARRAY = "SDO_ELEM_INFO_ARRAY";
    private static final String SDO_ORDINATE_ARRAY = "SDO_ORDINATE_ARRAY";

    OracleSdoGeometryDataType() {
        super(SDO_GEOMETRY, 2002, Struct.class, false);
    }

    public Object typeCast(Object value) throws TypeCastException {
        return this.typeCast(value, null);
    }

    private BigDecimal[] parseNumbers(String input, String name) throws ParseException {
        logger.debug("parseNumbers(input={}, name={}) - start", (Object)input, (Object)name);
        if (input == null) {
            return null;
        }
        int workIndex = 0;
        if (name != null) {
            if (!input.startsWith(name)) {
                throw new ParseException("missing " + name, workIndex);
            }
            workIndex += name.length();
        }
        if (workIndex + 1 >= input.length() || input.charAt(workIndex) != '(') {
            throw new ParseException("missing (", workIndex);
        }
        if (input.charAt(input.length() - 1) != ')') {
            throw new ParseException("missing )", input.length() - 1);
        }
        String[] numberStrings = input.substring(workIndex + 1, input.length() - 1).split(",");
        if (numberStrings == null) {
            return null;
        }
        BigDecimal[] returnVal = new BigDecimal[numberStrings.length];
        for (int index = 0; index < numberStrings.length; ++index) {
            String valToParse = numberStrings[index].trim();
            logger.debug("parsing {} as BigDecimal", (Object)valToParse);
            returnVal[index] = NULL.equals(valToParse) ? null : new BigDecimal(valToParse);
        }
        return returnVal;
    }

    public Object typeCast(Object value, Connection connection) throws TypeCastException {
        logger.debug("typeCast(value={}) - start", value);
        if (value == null || value == ITable.NO_VALUE) {
            return null;
        }
        if (value instanceof Struct) {
            return value;
        }
        if (value instanceof String) {
            if (connection == null) {
                throw new TypeCastException(value, this);
            }
            try {
                STRUCT pointStruct;
                BigDecimal[] ordinates;
                BigDecimal[] elemInfos;
                BigDecimal[] pointValues;
                int workingIndex;
                String upperVal = ((String)value).toUpperCase();
                if (NULL.equals(upperVal)) {
                    return null;
                }
                if (!upperVal.startsWith("SDO_GEOMETRY(") || !upperVal.endsWith(")")) {
                    throw new TypeCastException(value, this);
                }
                String workingVal = upperVal.substring("SDO_GEOMETRY(".length(), upperVal.length() - 1);
                int commaIndex = workingVal.indexOf(",", workingIndex = 0);
                if (commaIndex == -1 || commaIndex == workingIndex || commaIndex + 1 == workingVal.length()) {
                    throw new TypeCastException(value, this);
                }
                String gtypeString = workingVal.substring(workingIndex, commaIndex).trim();
                Integer gtype = NULL.equals(gtypeString) ? null : new Integer(gtypeString);
                workingIndex = commaIndex + 1;
                if ((commaIndex = workingVal.indexOf(",", workingIndex)) == -1 || commaIndex == workingIndex || commaIndex + 1 == workingVal.length()) {
                    throw new TypeCastException(value, this);
                }
                String sridString = workingVal.substring(workingIndex, commaIndex).trim();
                Integer srid = NULL.equals(sridString) ? null : new Integer(sridString);
                workingIndex = commaIndex + 1;
                workingVal = workingVal.substring(workingIndex).trim();
                workingIndex = 0;
                if (workingVal.startsWith(NULL)) {
                    pointValues = null;
                } else {
                    int closingParenIndex = workingVal.indexOf(")", workingIndex);
                    if (closingParenIndex == -1) {
                        throw new TypeCastException(value, this);
                    }
                    pointValues = this.parseNumbers(workingVal.substring(workingIndex, closingParenIndex + 1), SDO_POINT_TYPE);
                    workingIndex = closingParenIndex + 1;
                }
                commaIndex = workingVal.indexOf(",", workingIndex);
                if (commaIndex == -1 || commaIndex + 1 == workingVal.length()) {
                    throw new TypeCastException(value, this);
                }
                workingVal = workingVal.substring(commaIndex + 1).trim();
                workingIndex = 0;
                if (workingVal.startsWith(NULL)) {
                    elemInfos = null;
                } else {
                    int closingParenIndex = workingVal.indexOf(")", workingIndex);
                    if (closingParenIndex == -1) {
                        throw new TypeCastException(value, this);
                    }
                    elemInfos = this.parseNumbers(workingVal.substring(workingIndex, closingParenIndex + 1), SDO_ELEM_INFO_ARRAY);
                    workingIndex = closingParenIndex + 1;
                }
                commaIndex = workingVal.indexOf(",", workingIndex);
                if (commaIndex == -1 || commaIndex + 1 == workingVal.length()) {
                    throw new TypeCastException(value, this);
                }
                workingVal = workingVal.substring(commaIndex + 1).trim();
                workingIndex = 0;
                if (workingVal.startsWith(NULL)) {
                    ordinates = null;
                } else {
                    int closingParenIndex = workingVal.indexOf(")", workingIndex);
                    if (closingParenIndex == -1) {
                        throw new TypeCastException(value, this);
                    }
                    ordinates = this.parseNumbers(workingVal.substring(workingIndex, closingParenIndex + 1), SDO_ORDINATE_ARRAY);
                    workingIndex = closingParenIndex + 1;
                }
                if (pointValues == null) {
                    pointStruct = null;
                } else {
                    if (pointValues.length != 3) {
                        throw new TypeCastException(value, this);
                    }
                    StructDescriptor pointDescriptor = StructDescriptor.createDescriptor((String)SDO_POINT_TYPE, (Connection)connection);
                    Object[] pointAttributes = new Object[]{pointValues[0], pointValues[1], pointValues[2]};
                    pointStruct = new STRUCT(pointDescriptor, connection, pointAttributes);
                }
                StructDescriptor geometryDescriptor = StructDescriptor.createDescriptor((String)SDO_GEOMETRY, (Connection)connection);
                Object[] geometryAttributes = new Object[]{gtype, srid, pointStruct, elemInfos, ordinates};
                STRUCT geometryStruct = new STRUCT(geometryDescriptor, connection, geometryAttributes);
                return geometryStruct;
            }
            catch (ParseException e) {
                throw new TypeCastException(value, this, e);
            }
            catch (SQLException e) {
                throw new TypeCastException(value, this, e);
            }
        }
        throw new TypeCastException(value, this);
    }

    protected void appendNamedArray(StringBuffer buf, String name, Array array) throws SQLException {
        if (array == null) {
            buf.append(NULL);
        } else {
            buf.append(name);
            buf.append("(");
            Object[] elements = (Object[])array.getArray();
            for (int index = 0; index < elements.length; ++index) {
                buf.append(elements[index] == null ? NULL : elements[index]);
                if (index + 1 == elements.length) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        if (logger.isDebugEnabled()) {
            logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)new Integer(column), (Object)resultSet);
        }
        Object data = null;
        try {
            data = resultSet.getObject(column);
            if (data != null) {
                if (!(data instanceof STRUCT)) {
                    throw new TypeCastException(data, this);
                }
                Object[] attributes = ((STRUCT)data).getAttributes();
                StringBuffer buf = new StringBuffer();
                buf.append(SDO_GEOMETRY);
                buf.append("(");
                Object attribute = attributes[0];
                buf.append(attribute == null ? NULL : attribute);
                buf.append(", ");
                attribute = attributes[1];
                buf.append(attribute == null ? NULL : attribute);
                buf.append(", ");
                attribute = attributes[2];
                if (attribute == null) {
                    buf.append(NULL);
                } else {
                    buf.append(SDO_POINT_TYPE);
                    buf.append("(");
                    Object[] pointAttributes = ((STRUCT)attribute).getAttributes();
                    buf.append(pointAttributes[0] == null ? NULL : pointAttributes[0]);
                    buf.append(", ");
                    buf.append(pointAttributes[1] == null ? NULL : pointAttributes[1]);
                    buf.append(", ");
                    buf.append(pointAttributes[2] == null ? NULL : pointAttributes[2]);
                    buf.append(")");
                }
                buf.append(", ");
                this.appendNamedArray(buf, SDO_ELEM_INFO_ARRAY, (Array)attributes[3]);
                buf.append(", ");
                this.appendNamedArray(buf, SDO_ORDINATE_ARRAY, (Array)attributes[4]);
                buf.append(")");
                return buf.toString();
            }
            return NULL;
        }
        catch (SQLException e) {
            throw new TypeCastException(data, this, e);
        }
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        Object castValue = this.typeCast(value, statement.getConnection());
        if (castValue == null) {
            statement.setNull(column, 2002, SDO_GEOMETRY);
        } else {
            statement.setObject(column, castValue, 2002);
        }
    }
}

