/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.dbunit.AbstractDatabaseTester;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiDatabaseTester
extends AbstractDatabaseTester {
    private static final Logger logger = LoggerFactory.getLogger(JndiDatabaseTester.class);
    private DataSource dataSource;
    private Properties environment;
    private boolean initialized = false;
    private String lookupName;

    public JndiDatabaseTester(String lookupName) {
        this(null, lookupName);
    }

    public JndiDatabaseTester(Properties environment, String lookupName) {
        this(environment, lookupName, null);
    }

    public JndiDatabaseTester(Properties environment, String lookupName, String schema) {
        super(schema);
        if (lookupName == null) {
            throw new NullPointerException("The parameter 'lookupName' must not be null");
        }
        this.lookupName = lookupName;
        this.environment = environment;
    }

    public IDatabaseConnection getConnection() throws Exception {
        logger.trace("getConnection() - start");
        if (!this.initialized) {
            this.initialize();
        }
        return new DatabaseConnection(this.dataSource.getConnection(), this.getSchema());
    }

    private void initialize() throws NamingException {
        logger.trace("initialize() - start");
        InitialContext context = new InitialContext(this.environment);
        this.assertNotNullNorEmpty("lookupName", this.lookupName);
        Object obj = context.lookup(this.lookupName);
        this.assertTrue("JNDI object with [" + this.lookupName + "] not found", obj != null);
        this.assertTrue("Object [" + obj + "] at JNDI location [" + this.lookupName + "] is not of type [" + DataSource.class.getName() + "]", obj instanceof DataSource);
        this.dataSource = (DataSource)obj;
        this.assertTrue("DataSource is not set", this.dataSource != null);
        this.initialized = true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append("lookupName=").append(this.lookupName);
        sb.append(", environment=").append(this.environment);
        sb.append(", initialized=").append(this.initialized);
        sb.append(", dataSource=").append(this.dataSource);
        sb.append(", schema=").append(super.getSchema());
        sb.append("]");
        return sb.toString();
    }
}

