/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ant;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.dbunit.DatabaseUnitException;
import org.dbunit.ant.Compare;
import org.dbunit.ant.DbConfig;
import org.dbunit.ant.DbUnitTaskStep;
import org.dbunit.ant.Export;
import org.dbunit.ant.Operation;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.ForwardOnlyResultSetTableFactory;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUnitTask
extends Task {
    private static final Logger logger = LoggerFactory.getLogger(DbUnitTask.class);
    private Connection conn = null;
    private String driver = null;
    private String url = null;
    private String userId = null;
    private String password = null;
    private String schema = null;
    private List steps = new ArrayList();
    private Path classpath;
    private AntClassLoader loader;
    private DbConfig dbConfig;
    private Boolean useQualifiedTableNames = null;
    private Boolean supportBatchStatement = null;
    private Boolean datatypeWarning = null;
    private String escapePattern = null;
    private String dataTypeFactory = null;
    private String batchSize = null;
    private String fetchSize = null;
    private Boolean skipOracleRecycleBinTables = null;
    private Boolean allowEmptyFields = null;

    public void setDriver(String driver) {
        logger.trace("setDriver(driver={}) - start", (Object)driver);
        this.driver = driver;
    }

    public void setUrl(String url) {
        logger.trace("setUrl(url={}) - start", (Object)url);
        this.url = url;
    }

    public void setUserid(String userId) {
        logger.trace("setUserid(userId={}) - start", (Object)userId);
        this.userId = userId;
    }

    public void setPassword(String password) {
        logger.trace("setPassword(password=*****) - start");
        this.password = password;
    }

    public void setSchema(String schema) {
        logger.trace("setSchema(schema={}) - start", (Object)schema);
        this.schema = schema;
    }

    public void setUseQualifiedTableNames(Boolean useQualifiedTableNames) {
        logger.trace("setUseQualifiedTableNames(useQualifiedTableNames={}) - start", (Object)String.valueOf(useQualifiedTableNames));
        this.useQualifiedTableNames = useQualifiedTableNames;
    }

    public void setSupportBatchStatement(Boolean supportBatchStatement) {
        logger.trace("setSupportBatchStatement(supportBatchStatement={}) - start", (Object)String.valueOf(supportBatchStatement));
        this.supportBatchStatement = supportBatchStatement;
    }

    public void setDatatypeWarning(Boolean datatypeWarning) {
        logger.trace("setDatatypeWarning(datatypeWarning={}) - start", (Object)String.valueOf(datatypeWarning));
        this.datatypeWarning = datatypeWarning;
    }

    public void setDatatypeFactory(String datatypeFactory) {
        logger.trace("setDatatypeFactory(datatypeFactory={}) - start", (Object)datatypeFactory);
        this.dataTypeFactory = datatypeFactory;
    }

    public void setEscapePattern(String escapePattern) {
        logger.trace("setEscapePattern(escapePattern={}) - start", (Object)escapePattern);
        this.escapePattern = escapePattern;
    }

    public DbConfig getDbConfig() {
        return this.dbConfig;
    }

    public void addDbConfig(DbConfig dbConfig) {
        logger.trace("addDbConfig(dbConfig={}) - start", (Object)dbConfig);
        this.dbConfig = dbConfig;
    }

    public void setClasspath(Path classpath) {
        logger.trace("setClasspath(classpath={}) - start", (Object)classpath);
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        logger.trace("createClasspath() - start");
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        logger.trace("setClasspathRef(r={}) - start", (Object)r);
        this.createClasspath().setRefid(r);
    }

    public List getSteps() {
        return this.steps;
    }

    public void addOperation(Operation operation) {
        logger.trace("addOperation({}) - start", (Object)operation);
        this.steps.add(operation);
    }

    public void addCompare(Compare compare) {
        logger.trace("addCompare({}) - start", (Object)compare);
        this.steps.add(compare);
    }

    public void addExport(Export export) {
        logger.trace("addExport(export={}) - start", (Object)export);
        this.steps.add(export);
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public String getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(String fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setSkipOracleRecycleBinTables(Boolean skipOracleRecycleBinTables) {
        this.skipOracleRecycleBinTables = skipOracleRecycleBinTables;
    }

    public void execute() throws BuildException {
        logger.trace("execute() - start");
        try {
            IDatabaseConnection connection = this.createConnection();
            ListIterator stepIter = this.steps.listIterator();
            while (stepIter.hasNext()) {
                DbUnitTaskStep step = (DbUnitTaskStep)stepIter.next();
                this.log(step.getLogMessage(), 2);
                step.execute(connection);
            }
        }
        catch (DatabaseUnitException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
        catch (SQLException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
        finally {
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException e) {
                logger.error("execute()", (Throwable)e);
            }
        }
    }

    protected IDatabaseConnection createConnection() throws SQLException {
        logger.trace("createConnection() - start");
        if (this.driver == null) {
            throw new BuildException("Driver attribute must be set!", this.getLocation());
        }
        if (this.userId == null) {
            throw new BuildException("User Id attribute must be set!", this.getLocation());
        }
        if (this.password == null) {
            throw new BuildException("Password attribute must be set!", this.getLocation());
        }
        if (this.url == null) {
            throw new BuildException("Url attribute must be set!", this.getLocation());
        }
        if (this.steps.size() == 0) {
            throw new BuildException("Must declare at least one step in a <dbunit> task!", this.getLocation());
        }
        Driver driverInstance = null;
        try {
            Class dc;
            if (this.classpath != null) {
                this.log("Loading " + this.driver + " using AntClassLoader with classpath " + this.classpath, 3);
                this.loader = new AntClassLoader(this.getProject(), this.classpath);
                dc = this.loader.loadClass(this.driver);
            } else {
                this.log("Loading " + this.driver + " using system loader.", 3);
                dc = Class.forName(this.driver);
            }
            driverInstance = (Driver)dc.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Class Not Found: JDBC driver " + this.driver + " could not be loaded", (Throwable)e, this.getLocation());
        }
        catch (IllegalAccessException e) {
            throw new BuildException("Illegal Access: JDBC driver " + this.driver + " could not be loaded", (Throwable)e, this.getLocation());
        }
        catch (InstantiationException e) {
            throw new BuildException("Instantiation Exception: JDBC driver " + this.driver + " could not be loaded", (Throwable)e, this.getLocation());
        }
        this.log("connecting to " + this.url, 3);
        Properties info = new Properties();
        info.put("user", this.userId);
        info.put("password", this.password);
        this.conn = driverInstance.connect(this.url, info);
        if (this.conn == null) {
            throw new SQLException("No suitable Driver for " + this.url);
        }
        this.conn.setAutoCommit(true);
        IDatabaseConnection connection = this.createDatabaseConnection(this.conn, this.schema);
        return connection;
    }

    protected IDatabaseConnection createDatabaseConnection(Connection jdbcConnection, String dbSchema) {
        logger.trace("createDatabaseConnection(jdbcConnection={}, dbSchema={}) - start", (Object)jdbcConnection, (Object)dbSchema);
        DatabaseConnection connection = null;
        try {
            connection = new DatabaseConnection(jdbcConnection, dbSchema);
        }
        catch (DatabaseUnitException e) {
            throw new BuildException("Could not create dbunit connection object", (Throwable)e);
        }
        DatabaseConfig config = connection.getConfig();
        config.setProperty("http://www.dbunit.org/properties/resultSetTableFactory", new ForwardOnlyResultSetTableFactory());
        if (this.dbConfig != null) {
            try {
                this.dbConfig.copyTo(config);
            }
            catch (DatabaseUnitException e) {
                throw new BuildException("Could not populate dbunit config object", (Throwable)e, this.getLocation());
            }
        }
        this.copyAttributes(config);
        this.log("Created connection for schema '" + this.schema + "' with config: " + config, 3);
        return connection;
    }

    private void copyAttributes(DatabaseConfig config) {
        if (this.supportBatchStatement != null) {
            config.setFeature("http://www.dbunit.org/features/batchedStatements", this.supportBatchStatement);
        }
        if (this.useQualifiedTableNames != null) {
            config.setFeature("http://www.dbunit.org/features/qualifiedTableNames", this.useQualifiedTableNames);
        }
        if (this.datatypeWarning != null) {
            config.setFeature("http://www.dbunit.org/features/datatypeWarning", this.datatypeWarning);
        }
        if (this.skipOracleRecycleBinTables != null) {
            config.setFeature("http://www.dbunit.org/features/skipOracleRecycleBinTables", this.skipOracleRecycleBinTables);
        }
        if (this.allowEmptyFields != null) {
            config.setFeature("http://www.dbunit.org/features/allowEmptyFields", this.allowEmptyFields);
        }
        if (this.escapePattern != null) {
            config.setProperty("http://www.dbunit.org/properties/escapePattern", this.escapePattern);
        }
        if (this.batchSize != null) {
            Integer batchSizeInteger = new Integer(this.batchSize);
            config.setProperty("http://www.dbunit.org/properties/batchSize", batchSizeInteger);
        }
        if (this.fetchSize != null) {
            config.setProperty("http://www.dbunit.org/properties/fetchSize", new Integer(this.fetchSize));
        }
        if (this.dataTypeFactory != null) {
            try {
                IDataTypeFactory dataTypeFactory = (IDataTypeFactory)Class.forName(this.dataTypeFactory).newInstance();
                config.setProperty("http://www.dbunit.org/properties/datatypeFactory", dataTypeFactory);
            }
            catch (ClassNotFoundException e) {
                throw new BuildException("Class Not Found: DataType factory " + this.driver + " could not be loaded", (Throwable)e, this.getLocation());
            }
            catch (IllegalAccessException e) {
                throw new BuildException("Illegal Access: DataType factory " + this.driver + " could not be loaded", (Throwable)e, this.getLocation());
            }
            catch (InstantiationException e) {
                throw new BuildException("Instantiation Exception: DataType factory " + this.driver + " could not be loaded", (Throwable)e, this.getLocation());
            }
        }
    }
}

