/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database.search;

import org.dbunit.util.search.Edge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForeignKeyRelationshipEdge
extends Edge {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String fkColumn;
    private String pkColumn;

    public ForeignKeyRelationshipEdge(String tableFrom, String tableTo, String fkColumn, String pkColumn) {
        super((Comparable)((Object)tableFrom), (Comparable)((Object)tableTo));
        this.fkColumn = fkColumn;
        this.pkColumn = pkColumn;
    }

    public String getFKColumn() {
        return this.fkColumn;
    }

    public String getPKColumn() {
        return this.pkColumn;
    }

    public String toString() {
        return this.getFrom() + "(" + this.getFKColumn() + ")->" + this.getTo() + "(" + this.getPKColumn() + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fkColumn == null ? 0 : this.fkColumn.hashCode());
        result = 31 * result + (this.pkColumn == null ? 0 : this.pkColumn.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ForeignKeyRelationshipEdge other = (ForeignKeyRelationshipEdge)obj;
        if (this.fkColumn == null ? other.fkColumn != null : !this.fkColumn.equals(other.fkColumn)) {
            return false;
        }
        return !(this.pkColumn == null ? other.pkColumn != null : !this.pkColumn.equals(other.pkColumn));
    }

    public int compareTo(Object o) {
        this.log.debug("compareTo(o={}) - start", o);
        ForeignKeyRelationshipEdge that = (ForeignKeyRelationshipEdge)o;
        int result = super.compareTo(that);
        if (result == 0) {
            result = this.pkColumn.compareTo(that.pkColumn);
        }
        if (result == 0) {
            result = this.fkColumn.compareTo(that.fkColumn);
        }
        return result;
    }
}

