/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.database.AmbiguousTableNameException;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.CaseInsensitiveTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchTableException;
import org.dbunit.dataset.OrderedTableNameMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseInsensitiveDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger(CaseInsensitiveDataSet.class);
    private final IDataSet _dataSet;
    private OrderedTableNameMap orderedTableMap;

    public CaseInsensitiveDataSet(IDataSet dataSet) throws AmbiguousTableNameException, DataSetException {
        this._dataSet = dataSet;
        this.orderedTableMap = new OrderedTableNameMap(false);
        ITableIterator tableIterator = this._dataSet.iterator();
        while (tableIterator.next()) {
            ITable table = tableIterator.getTable();
            String tableName = table.getTableMetaData().getTableName();
            this.orderedTableMap.add(tableName.toUpperCase(), tableName);
        }
    }

    private String getInternalTableName(String tableName) throws DataSetException {
        logger.debug("getInternalTableName(tableName={}) - start", (Object)tableName);
        String originalTableName = (String)this.orderedTableMap.get(tableName.toUpperCase());
        if (originalTableName == null) {
            throw new NoSuchTableException(tableName);
        }
        return originalTableName;
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("createIterator(reversed={}) - start", (Object)String.valueOf(reversed));
        }
        return new CaseInsensitiveIterator(reversed ? this._dataSet.reverseIterator() : this._dataSet.iterator());
    }

    public String[] getTableNames() throws DataSetException {
        return this._dataSet.getTableNames();
    }

    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        logger.debug("getTableMetaData(tableName={}) - start", (Object)tableName);
        return this._dataSet.getTableMetaData(this.getInternalTableName(tableName));
    }

    public ITable getTable(String tableName) throws DataSetException {
        logger.debug("getTable(tableName={}) - start", (Object)tableName);
        ITable table = this._dataSet.getTable(this.getInternalTableName(tableName));
        return new CaseInsensitiveTable(table);
    }

    private class CaseInsensitiveIterator
    implements ITableIterator {
        private final ITableIterator _iterator;

        public CaseInsensitiveIterator(ITableIterator iterator) {
            this._iterator = iterator;
        }

        public boolean next() throws DataSetException {
            return this._iterator.next();
        }

        public ITableMetaData getTableMetaData() throws DataSetException {
            return this._iterator.getTableMetaData();
        }

        public ITable getTable() throws DataSetException {
            return new CaseInsensitiveTable(this._iterator.getTable());
        }
    }
}

