/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataType
extends DataType {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDataType.class);
    private final String _name;
    private final int _sqlType;
    private final Class _classType;
    private final boolean _isNumber;

    public AbstractDataType(String name, int sqlType, Class classType, boolean isNumber) {
        this._sqlType = sqlType;
        this._name = name;
        this._classType = classType;
        this._isNumber = isNumber;
    }

    public int compare(Object o1, Object o2) throws TypeCastException {
        logger.debug("compare(o1={}, o2={}) - start", o1, o2);
        try {
            if (this.areObjectsEqual(o1, o2)) {
                return 0;
            }
            Object value1 = this.typeCast(o1);
            Object value2 = this.typeCast(o2);
            if (value1 == null && value2 == null) {
                return 0;
            }
            if (value1 == null && value2 != null) {
                return -1;
            }
            if (value1 != null && value2 == null) {
                return 1;
            }
            return this.compareNonNulls(value1, value2);
        }
        catch (ClassCastException e) {
            throw new TypeCastException(e);
        }
    }

    protected int compareNonNulls(Object value1, Object value2) throws TypeCastException {
        logger.debug("compareNonNulls(value1={}, value2={}) - start", value1, value2);
        Comparable value1comp = (Comparable)value1;
        Comparable value2comp = (Comparable)value2;
        return value1comp.compareTo(value2comp);
    }

    protected final boolean areObjectsEqual(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        return o1 != null && o1.equals(o2);
    }

    public int getSqlType() {
        logger.debug("getSqlType() - start");
        return this._sqlType;
    }

    public Class getTypeClass() {
        logger.debug("getTypeClass() - start");
        return this._classType;
    }

    public boolean isNumber() {
        logger.debug("isNumber() - start");
        return this._isNumber;
    }

    public boolean isDateTime() {
        logger.debug("isDateTime() - start");
        return false;
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        Object value;
        if (logger.isDebugEnabled()) {
            logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)new Integer(column), (Object)resultSet);
        }
        if ((value = resultSet.getObject(column)) == null || resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        if (logger.isDebugEnabled()) {
            logger.debug("setSqlValue(value={}, column={}, statement={}) - start", new Object[]{value, new Integer(column), statement});
        }
        statement.setObject(column, this.typeCast(value), this.getSqlType());
    }

    protected final Class loadClass(String clazz, Connection connection) throws ClassNotFoundException {
        ClassLoader connectionClassLoader = connection.getClass().getClassLoader();
        return this.loadClass(clazz, connectionClassLoader);
    }

    protected final Class loadClass(String clazz, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> loadedClass = classLoader.loadClass(clazz);
        return loadedClass;
    }

    public String toString() {
        return this._name;
    }
}

