/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.util.Arrays;
import java.util.Collection;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunit.dataset.datatype.IDbProductRelatable;
import org.dbunit.dataset.datatype.NumberTolerantDataType;
import org.dbunit.dataset.datatype.ToleratedDeltaMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataTypeFactory
implements IDataTypeFactory,
IDbProductRelatable {
    private ToleratedDeltaMap _toleratedDeltaMap = new ToleratedDeltaMap();
    private static final Logger logger = LoggerFactory.getLogger(DefaultDataTypeFactory.class);
    private static final Collection DATABASE_PRODUCTS = Arrays.asList("derby");

    public Collection getValidDbProducts() {
        return DATABASE_PRODUCTS;
    }

    public DataType createDataType(int sqlType, String sqlTypeName) throws DataTypeException {
        if (logger.isDebugEnabled()) {
            logger.debug("createDataType(sqlType={}, sqlTypeName={}) - start", (Object)new Integer(sqlType), (Object)sqlTypeName);
        }
        DataType dataType = DataType.UNKNOWN;
        if (sqlType != 1111) {
            dataType = DataType.forSqlType(sqlType);
        } else {
            if ("BLOB".equals(sqlTypeName)) {
                return DataType.BLOB;
            }
            if ("CLOB".equals(sqlTypeName)) {
                return DataType.CLOB;
            }
        }
        return dataType;
    }

    public DataType createDataType(int sqlType, String sqlTypeName, String tableName, String columnName) throws DataTypeException {
        ToleratedDeltaMap.ToleratedDelta delta;
        if (logger.isDebugEnabled()) {
            logger.debug("createDataType(sqlType={} , sqlTypeName={}, tableName={}, columnName={}) - start", new Object[]{new Integer(sqlType), sqlTypeName, tableName, columnName});
        }
        if ((sqlType == 2 || sqlType == 3) && (delta = this._toleratedDeltaMap.findToleratedDelta(tableName, columnName)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Creating NumberTolerantDataType for table={}, column={}, toleratedDelta={}", new Object[]{tableName, columnName, delta.getToleratedDelta()});
            }
            NumberTolerantDataType type = new NumberTolerantDataType("NUMERIC_WITH_TOLERATED_DELTA", sqlType, delta.getToleratedDelta());
            return type;
        }
        return this.createDataType(sqlType, sqlTypeName);
    }

    public ToleratedDeltaMap getToleratedDeltaMap() {
        return this._toleratedDeltaMap;
    }

    public void addToleratedDelta(ToleratedDeltaMap.ToleratedDelta delta) {
        this._toleratedDeltaMap.addToleratedDelta(delta);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append("_toleratedDeltaMap=").append(this._toleratedDeltaMap);
        sb.append("]");
        return sb.toString();
    }
}

