/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableIterator;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.OrderedTableNameMap;
import org.dbunit.dataset.excel.XlsDataSetWriter;
import org.dbunit.dataset.excel.XlsTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger(XlsDataSet.class);
    private final OrderedTableNameMap _tables = super.createTableNameMap();

    public XlsDataSet(File file) throws IOException, DataSetException {
        this(new FileInputStream(file));
    }

    public XlsDataSet(InputStream in) throws IOException, DataSetException {
        Workbook workbook;
        try {
            workbook = WorkbookFactory.create((InputStream)in);
        }
        catch (InvalidFormatException e) {
            throw new IOException(e);
        }
        int sheetCount = workbook.getNumberOfSheets();
        for (int i = 0; i < sheetCount; ++i) {
            XlsTable table = new XlsTable(workbook.getSheetName(i), workbook.getSheetAt(i));
            this._tables.add(table.getTableMetaData().getTableName(), table);
        }
    }

    public static void write(IDataSet dataSet, OutputStream out) throws IOException, DataSetException {
        logger.debug("write(dataSet={}, out={}) - start", (Object)dataSet, (Object)out);
        new XlsDataSetWriter().write(dataSet, out);
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("createIterator(reversed={}) - start", (Object)String.valueOf(reversed));
        }
        ITable[] tables = this._tables.orderedValues().toArray(new ITable[0]);
        return new DefaultTableIterator(tables, reversed);
    }
}

