/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.oracle;

import org.dbunit.dataset.datatype.BinaryStreamDataType;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.datatype.StringDataType;
import org.dbunit.ext.oracle.OracleDataTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oracle10DataTypeFactory
extends OracleDataTypeFactory {
    private static final Logger logger = LoggerFactory.getLogger(Oracle10DataTypeFactory.class);
    protected static final DataType CLOB_AS_STRING = new StringDataType("CLOB", 2005);
    protected static final DataType BLOB_AS_STREAM = new BinaryStreamDataType("BLOB", 2004);

    public DataType createDataType(int sqlType, String sqlTypeName) throws DataTypeException {
        if (logger.isDebugEnabled()) {
            logger.debug("createDataType(sqlType={}, sqlTypeName={}) - start", (Object)String.valueOf(sqlType), (Object)sqlTypeName);
        }
        if ("BLOB".equals(sqlTypeName)) {
            return BLOB_AS_STREAM;
        }
        if ("CLOB".equals(sqlTypeName)) {
            return CLOB_AS_STRING;
        }
        return super.createDataType(sqlType, sqlTypeName);
    }
}

