/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.postgresql;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CitextType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger(CitextType.class);

    public CitextType() {
        super("citext", 1111, String.class, false);
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        return resultSet.getString(column);
    }

    public void setSqlValue(Object uuid, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        statement.setObject(column, this.getCitext(uuid, statement.getConnection()));
    }

    public Object typeCast(Object arg0) throws TypeCastException {
        return arg0.toString();
    }

    private Object getCitext(Object value, Connection connection) throws TypeCastException {
        logger.debug("getCitext(value={}, connection={}) - start", value, (Object)connection);
        Object tempCitext = null;
        try {
            Class aPGObjectClass = super.loadClass("org.postgresql.util.PGobject", connection);
            Constructor ct = aPGObjectClass.getConstructor(null);
            tempCitext = ct.newInstance(null);
            Method setTypeMethod = aPGObjectClass.getMethod("setType", String.class);
            setTypeMethod.invoke(tempCitext, "citext");
            Method setValueMethod = aPGObjectClass.getMethod("setValue", String.class);
            setValueMethod.invoke(tempCitext, value.toString());
        }
        catch (ClassNotFoundException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (InvocationTargetException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (NoSuchMethodException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (IllegalAccessException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (InstantiationException e) {
            throw new TypeCastException(value, this, e);
        }
        return tempCitext;
    }
}

