/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.endpoints;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.websocket.CloseReason;
import javax.websocket.DecodeException;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.message.MessageInputStream;
import org.eclipse.jetty.websocket.common.message.MessageReader;
import org.eclipse.jetty.websocket.common.message.SimpleBinaryMessage;
import org.eclipse.jetty.websocket.common.message.SimpleTextMessage;
import org.eclipse.jetty.websocket.jsr356.JsrSession;
import org.eclipse.jetty.websocket.jsr356.annotations.JsrEvents;
import org.eclipse.jetty.websocket.jsr356.endpoints.AbstractJsrEventDriver;
import org.eclipse.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.eclipse.jetty.websocket.jsr356.messages.BinaryPartialOnMessage;
import org.eclipse.jetty.websocket.jsr356.messages.TextPartialOnMessage;

public class JsrAnnotatedEventDriver
extends AbstractJsrEventDriver {
    private static final Logger LOG = Log.getLogger(JsrAnnotatedEventDriver.class);
    private final JsrEvents<?, ?> events;

    public JsrAnnotatedEventDriver(WebSocketPolicy policy, EndpointInstance endpointInstance, JsrEvents<?, ?> events) {
        super(policy, endpointInstance);
        this.events = events;
    }

    @Override
    public void init(JsrSession jsrsession) {
        this.events.init(jsrsession);
    }

    @Override
    public void onBinaryFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onBinaryFrame({}, {})", BufferUtil.toDetailString(buffer), fin);
            LOG.debug("events.onBinary={}", this.events.hasBinary());
            LOG.debug("events.onBinaryStream={}", this.events.hasBinaryStream());
        }
        boolean handled = false;
        if (this.events.hasBinary()) {
            handled = true;
            if (this.activeMessage == null) {
                if (this.events.isBinaryPartialSupported()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Partial Binary Message: fin={}", fin);
                    }
                    this.activeMessage = new BinaryPartialOnMessage(this);
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Whole Binary Message", new Object[0]);
                    }
                    this.activeMessage = new SimpleBinaryMessage(this);
                }
            }
        }
        if (this.events.hasBinaryStream()) {
            handled = true;
            if (this.activeMessage == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Binary Message InputStream", new Object[0]);
                }
                final MessageInputStream stream = new MessageInputStream();
                this.activeMessage = stream;
                this.dispatch(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JsrAnnotatedEventDriver.this.events.callBinaryStream(JsrAnnotatedEventDriver.this.jsrsession.getAsyncRemote(), JsrAnnotatedEventDriver.this.websocket, stream);
                        }
                        catch (IOException | DecodeException e) {
                            JsrAnnotatedEventDriver.this.onFatalError(e);
                        }
                    }
                });
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("handled = {}", handled);
        }
        if (handled && this.activeMessage != null) {
            this.appendMessage(buffer, fin);
        }
    }

    @Override
    public void onBinaryMessage(byte[] data) {
        if (data == null) {
            return;
        }
        ByteBuffer buf = ByteBuffer.wrap(data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("onBinaryMessage({})", BufferUtil.toDetailString(buf));
        }
        try {
            this.events.callBinary(this.jsrsession.getAsyncRemote(), this.websocket, buf, true);
        }
        catch (DecodeException e) {
            this.onFatalError(e);
        }
    }

    @Override
    protected void onClose(CloseReason closereason) {
        this.events.callClose(this.websocket, closereason);
    }

    @Override
    public void onConnect() {
        this.events.callOpen(this.websocket, this.config);
    }

    @Override
    public void onError(Throwable cause) {
        this.events.callError(this.websocket, cause);
    }

    private void onFatalError(Throwable t) {
        this.onError(t);
    }

    @Override
    public void onFrame(Frame frame) {
    }

    @Override
    public void onInputStream(InputStream stream) {
        try {
            this.events.callBinaryStream(this.jsrsession.getAsyncRemote(), this.websocket, stream);
        }
        catch (IOException | DecodeException e) {
            this.onFatalError(e);
        }
    }

    public void onPartialBinaryMessage(ByteBuffer buffer, boolean fin) {
        try {
            this.events.callBinary(this.jsrsession.getAsyncRemote(), this.websocket, buffer, fin);
        }
        catch (DecodeException e) {
            this.onFatalError(e);
        }
    }

    public void onPartialTextMessage(String message, boolean fin) {
        try {
            this.events.callText(this.jsrsession.getAsyncRemote(), this.websocket, message, fin);
        }
        catch (DecodeException e) {
            this.onFatalError(e);
        }
    }

    @Override
    public void onPing(ByteBuffer buffer) {
        try {
            this.events.callPong(this.jsrsession.getAsyncRemote(), this.websocket, buffer);
        }
        catch (IOException | DecodeException e) {
            this.onFatalError(e);
        }
    }

    @Override
    public void onPong(ByteBuffer buffer) {
        try {
            this.events.callPong(this.jsrsession.getAsyncRemote(), this.websocket, buffer);
        }
        catch (IOException | DecodeException e) {
            this.onFatalError(e);
        }
    }

    @Override
    public void onReader(Reader reader) {
        try {
            this.events.callTextStream(this.jsrsession.getAsyncRemote(), this.websocket, reader);
        }
        catch (IOException | DecodeException e) {
            this.onFatalError(e);
        }
    }

    @Override
    public void onTextFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onTextFrame({}, {})", BufferUtil.toDetailString(buffer), fin);
            LOG.debug("events.hasText={}", this.events.hasText());
            LOG.debug("events.hasTextStream={}", this.events.hasTextStream());
        }
        boolean handled = false;
        if (this.events.hasText()) {
            handled = true;
            if (this.activeMessage == null) {
                if (this.events.isTextPartialSupported()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Partial Text Message: fin={}", fin);
                    }
                    this.activeMessage = new TextPartialOnMessage(this);
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Whole Text Message", new Object[0]);
                    }
                    this.activeMessage = new SimpleTextMessage(this);
                }
            }
        }
        if (this.events.hasTextStream()) {
            handled = true;
            if (this.activeMessage == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Text Message Writer", new Object[0]);
                }
                final MessageReader stream = new MessageReader(new MessageInputStream());
                this.activeMessage = stream;
                this.dispatch(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JsrAnnotatedEventDriver.this.events.callTextStream(JsrAnnotatedEventDriver.this.jsrsession.getAsyncRemote(), JsrAnnotatedEventDriver.this.websocket, stream);
                        }
                        catch (IOException | DecodeException e) {
                            JsrAnnotatedEventDriver.this.onFatalError(e);
                        }
                    }
                });
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("handled = {}", handled);
        }
        if (handled && this.activeMessage != null) {
            this.appendMessage(buffer, fin);
        }
    }

    @Override
    public void onTextMessage(String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onText({})", message);
        }
        try {
            this.events.callText(this.jsrsession.getAsyncRemote(), this.websocket, message, true);
        }
        catch (DecodeException e) {
            this.onFatalError(e);
        }
    }

    @Override
    public void setPathParameters(Map<String, String> pathParameters) {
        this.events.setPathParameters(pathParameters);
    }

    public String toString() {
        return String.format("%s[websocket=%s]", this.getClass().getSimpleName(), this.websocket);
    }
}

