/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.nio.ByteBuffer;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpContent;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.http.HttpChannelOverHTTP;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;

public class HttpSenderOverHTTP
extends HttpSender {
    private final HttpGenerator generator = new HttpGenerator();

    public HttpSenderOverHTTP(HttpChannelOverHTTP channel) {
        super(channel);
    }

    @Override
    public HttpChannelOverHTTP getHttpChannel() {
        return (HttpChannelOverHTTP)super.getHttpChannel();
    }

    @Override
    protected void sendHeaders(HttpExchange exchange, HttpContent content, Callback callback) {
        HttpRequest request = exchange.getRequest();
        ContentProvider requestContent = request.getContent();
        long contentLength = requestContent == null ? -1L : requestContent.getLength();
        String path = request.getPath();
        String query = request.getQuery();
        if (query != null) {
            path = path + "?" + query;
        }
        MetaData.Request requestInfo = new MetaData.Request(request.getMethod(), new HttpURI(path), request.getVersion(), request.getHeaders(), contentLength);
        try {
            HttpGenerator.Result result;
            HttpClient client = this.getHttpChannel().getHttpDestination().getHttpClient();
            ByteBufferPool bufferPool = client.getByteBufferPool();
            ByteBuffer header = bufferPool.acquire(client.getRequestBufferSize(), false);
            ByteBuffer chunk = null;
            ByteBuffer contentBuffer = null;
            boolean lastContent = false;
            if (!this.expects100Continue(request)) {
                content.advance();
                contentBuffer = content.getByteBuffer();
                lastContent = content.isLast();
            }
            block7: while (true) {
                result = this.generator.generateRequest(requestInfo, header, chunk, contentBuffer, lastContent);
                switch (result) {
                    case NEED_CHUNK: {
                        chunk = bufferPool.acquire(12, false);
                        continue block7;
                    }
                    case FLUSH: {
                        boolean hasContent;
                        boolean hasChunk;
                        int size = 1;
                        boolean bl = hasChunk = chunk != null;
                        if (hasChunk) {
                            ++size;
                        }
                        boolean bl2 = hasContent = contentBuffer != null;
                        if (hasContent) {
                            ++size;
                        }
                        ByteBuffer[] toWrite = new ByteBuffer[size];
                        ByteBuffer[] toRecycle = new ByteBuffer[hasChunk ? 2 : 1];
                        toWrite[0] = header;
                        toRecycle[0] = header;
                        if (hasChunk) {
                            toWrite[1] = chunk;
                            toRecycle[1] = chunk;
                        }
                        if (hasContent) {
                            toWrite[toWrite.length - 1] = contentBuffer;
                        }
                        EndPoint endPoint = this.getHttpChannel().getHttpConnection().getEndPoint();
                        endPoint.write(new ByteBufferRecyclerCallback(callback, bufferPool, toRecycle), toWrite);
                        return;
                    }
                    case DONE: {
                        callback.failed(new HttpRequestException("Could not generate headers", request));
                        return;
                    }
                }
                break;
            }
            callback.failed(new IllegalStateException(result.toString()));
            return;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(x);
            }
            callback.failed(x);
            return;
        }
    }

    @Override
    protected void sendContent(HttpExchange exchange, HttpContent content, Callback callback) {
        try {
            HttpClient client = this.getHttpChannel().getHttpDestination().getHttpClient();
            ByteBufferPool bufferPool = client.getByteBufferPool();
            ByteBuffer chunk = null;
            block9: while (true) {
                ByteBuffer contentBuffer = content.getByteBuffer();
                boolean lastContent = content.isLast();
                HttpGenerator.Result result = this.generator.generateRequest(null, null, chunk, contentBuffer, lastContent);
                switch (result) {
                    case NEED_CHUNK: {
                        chunk = bufferPool.acquire(12, false);
                        continue block9;
                    }
                    case FLUSH: {
                        EndPoint endPoint = this.getHttpChannel().getHttpConnection().getEndPoint();
                        if (chunk != null) {
                            endPoint.write(new ByteBufferRecyclerCallback(callback, bufferPool, new ByteBuffer[]{chunk}), chunk, contentBuffer);
                        } else {
                            endPoint.write(callback, contentBuffer);
                        }
                        return;
                    }
                    case SHUTDOWN_OUT: {
                        this.shutdownOutput();
                        continue block9;
                    }
                    case CONTINUE: {
                        continue block9;
                    }
                    case DONE: {
                        assert (this.generator.isEnd());
                        callback.succeeded();
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(x);
            }
            callback.failed(x);
            return;
        }
    }

    @Override
    protected void reset() {
        this.generator.reset();
        super.reset();
    }

    @Override
    protected void dispose() {
        this.generator.abort();
        super.dispose();
        this.shutdownOutput();
    }

    private void shutdownOutput() {
        this.getHttpChannel().getHttpConnection().getEndPoint().shutdownOutput();
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", super.toString(), this.generator);
    }

    private class ByteBufferRecyclerCallback
    implements Callback {
        private final Callback callback;
        private final ByteBufferPool pool;
        private final ByteBuffer[] buffers;

        private ByteBufferRecyclerCallback(Callback callback, ByteBufferPool pool, ByteBuffer ... buffers) {
            this.callback = callback;
            this.pool = pool;
            this.buffers = buffers;
        }

        @Override
        public void succeeded() {
            for (ByteBuffer buffer : this.buffers) {
                assert (!buffer.hasRemaining());
                this.pool.release(buffer);
            }
            this.callback.succeeded();
        }

        @Override
        public void failed(Throwable x) {
            for (ByteBuffer buffer : this.buffers) {
                this.pool.release(buffer);
            }
            this.callback.failed(x);
        }
    }
}

