/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.common.io.AbstractWebSocketConnection;

public class WebSocketServerConnection
extends AbstractWebSocketConnection
implements Connection.UpgradeTo {
    private final AtomicBoolean opened = new AtomicBoolean(false);

    public WebSocketServerConnection(EndPoint endp, Executor executor, Scheduler scheduler, WebSocketPolicy policy, ByteBufferPool bufferPool) {
        super(endp, executor, scheduler, policy, bufferPool);
        if (policy.getIdleTimeout() > 0L) {
            endp.setIdleTimeout(policy.getIdleTimeout());
        }
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.getEndPoint().getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    @Override
    public void onUpgradeTo(ByteBuffer prefilled) {
        this.setInitialBuffer(prefilled);
    }

    @Override
    public void onOpen() {
        boolean beenOpened = this.opened.getAndSet(true);
        if (!beenOpened) {
            this.getSession().open();
        }
        super.onOpen();
    }

    @Override
    public void setNextIncomingFrames(IncomingFrames incoming) {
        this.getParser().setIncomingFramesHandler(incoming);
    }
}

