/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.coordination;

import java.net.InetAddress;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.internal.localization.TraceLocalization;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.coordination.CommandPropagator;
import org.eclipse.persistence.internal.sessions.coordination.ProfileMessageReceiveCommand;
import org.eclipse.persistence.internal.sessions.coordination.ProfileMessageSentCommand;
import org.eclipse.persistence.internal.sessions.coordination.ProfileRemoteChangeSetCommand;
import org.eclipse.persistence.internal.sessions.coordination.RCMCommand;
import org.eclipse.persistence.internal.sessions.coordination.RemoteConnection;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.coordination.Command;
import org.eclipse.persistence.sessions.coordination.CommandConverter;
import org.eclipse.persistence.sessions.coordination.CommandManager;
import org.eclipse.persistence.sessions.coordination.CommandProcessor;
import org.eclipse.persistence.sessions.coordination.DiscoveryManager;
import org.eclipse.persistence.sessions.coordination.ServiceId;
import org.eclipse.persistence.sessions.coordination.TransportManager;
import org.eclipse.persistence.sessions.coordination.rmi.RMITransportManager;

public class RemoteCommandManager
implements CommandManager {
    public static final String DEFAULT_CHANNEL = "EclipseLinkCommandChannel";
    public static final boolean DEFAULT_ASYNCHRONOUS_MODE = true;
    protected ServiceId serviceId = new ServiceId();
    protected DiscoveryManager discoveryManager;
    protected TransportManager transportManager;
    protected CommandProcessor commandProcessor;
    protected CommandConverter commandConverter;
    protected boolean isAsynchronous;
    protected boolean isEclipseLinkSession;
    protected ServerPlatform serverPlatform;
    protected boolean isStopped = true;

    public RemoteCommandManager(CommandProcessor commandProcessor) {
        this.setCommandProcessor(commandProcessor);
        this.transportManager = new RMITransportManager(this);
        this.discoveryManager = this.transportManager.createDiscoveryManager();
        this.serviceId.setChannel(DEFAULT_CHANNEL);
        this.isAsynchronous = true;
        commandProcessor.setCommandManager(this);
    }

    public RemoteCommandManager(CommandProcessor commandProcessor, TransportManager transportManager) {
        this(commandProcessor);
        this.transportManager = transportManager;
        this.discoveryManager = this.transportManager.createDiscoveryManager();
    }

    @Override
    public void initialize() {
        Object[] args = new Object[]{this.getServiceId()};
        this.logDebug("starting_rcm", args);
        if (this.getUrl() != null && this.getUrl().indexOf("$HOST") >= 0) {
            try {
                String ipAddress = InetAddress.getLocalHost().getHostAddress();
                this.replaceLocalHostIPAddress(ipAddress);
            }
            catch (Exception ex) {
                throw RemoteCommandManagerException.errorDiscoveringLocalHostIPAddress(ex);
            }
        }
        this.isStopped = false;
        if (this.discoveryManager != null) {
            this.discoveryManager.startDiscovery();
        } else {
            this.transportManager.createConnections();
        }
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    @Override
    public void shutdown() {
        Object[] args = new Object[]{this.getServiceId()};
        this.logDebug("stopping_rcm", args);
        if (this.discoveryManager != null) {
            this.discoveryManager.stopDiscovery();
            DiscoveryManager newDmgr = this.transportManager.createDiscoveryManager();
            newDmgr.shallowCopy(this.discoveryManager);
            this.discoveryManager = newDmgr;
        }
        this.isStopped = true;
        this.transportManager.discardConnections();
    }

    @Override
    public void propagateCommand(Object command) {
        Command newCommand;
        if (this.commandConverter != null) {
            Object[] args = new Object[]{command};
            this.logDebug("converting_to_toplink_command", args);
            if (this.isCommandProcessorASession()) {
                this.getCommandProcessor().processCommand(new ProfileMessageSentCommand());
            }
            newCommand = this.commandConverter.convertToEclipseLinkCommand(command);
        } else if (command instanceof Command) {
            newCommand = (Command)command;
        } else {
            Object[] args = new Object[]{command};
            this.logWarning("missing_converter", args);
            return;
        }
        newCommand.setServiceId(this.getServiceId());
        CommandPropagator propagator = new CommandPropagator(this, newCommand);
        if (this.shouldPropagateAsynchronously()) {
            propagator.asynchronousPropagateCommand();
        } else {
            propagator.synchronousPropagateCommand();
        }
    }

    public void processCommandFromRemoteConnection(Command command) {
        Object[] args = new Object[]{command.getClass().getName(), command.getServiceId()};
        this.logDebug("received_remote_command", args);
        if (this.isCommandProcessorASession()) {
            this.getCommandProcessor().processCommand(new ProfileMessageReceiveCommand());
        }
        if (command.isInternalCommand() || command instanceof RCMCommand) {
            this.logDebug("processing_internal_command", args);
            ((RCMCommand)command).executeWithRCM(this);
            return;
        }
        Object newCommand = command;
        if (this.commandConverter != null) {
            this.logDebug("converting_to_user_command", args);
            newCommand = this.commandConverter.convertToUserCommand(command);
        }
        this.logDebug("processing_remote_command", args);
        this.commandProcessor.processCommand(newCommand);
        if (this.isCommandProcessorASession()) {
            this.getCommandProcessor().processCommand(new ProfileRemoteChangeSetCommand());
        }
    }

    @Override
    public CommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    @Override
    public void setCommandProcessor(CommandProcessor newCommandProcessor) {
        this.commandProcessor = newCommandProcessor;
        if (newCommandProcessor instanceof Session) {
            this.isEclipseLinkSession = true;
        }
    }

    @Override
    public TransportManager getTransportManager() {
        return this.transportManager;
    }

    @Override
    public void setTransportManager(TransportManager newTransportManager) {
        this.transportManager = newTransportManager;
        this.discoveryManager = this.transportManager.createDiscoveryManager();
    }

    public void handleException(RuntimeException exception) {
        this.commandProcessor.handleException(exception);
    }

    public void newServiceDiscovered(ServiceId service) {
        RemoteConnection connection = this.transportManager.createConnection(service);
        this.transportManager.addConnectionToExternalService(connection);
    }

    @Override
    public DiscoveryManager getDiscoveryManager() {
        return this.discoveryManager;
    }

    @Override
    public CommandConverter getCommandConverter() {
        return this.commandConverter;
    }

    @Override
    public void setCommandConverter(CommandConverter newCommandConverter) {
        this.commandConverter = newCommandConverter;
    }

    public boolean shouldLogMessage(int logLevel) {
        return this.commandProcessor.shouldLogMessages(logLevel);
    }

    public boolean shouldLogDebugMessage() {
        return this.commandProcessor.shouldLogMessages(4);
    }

    public boolean shouldLogWarningMessage() {
        return this.commandProcessor.shouldLogMessages(2);
    }

    public void logMessage(int logLevel, String message, Object[] args) {
        if (this.commandProcessor.shouldLogMessages(logLevel)) {
            this.logMessageWithoutLevelCheck(logLevel, message, args);
        }
    }

    public void logMessageWithoutLevelCheck(int logLevel, String message, Object[] args) {
        String i18nmsg = message;
        if (logLevel == 1 || logLevel == 2) {
            i18nmsg = LoggingLocalization.buildMessage(message, args);
        } else if (logLevel == 3 || logLevel == 4) {
            i18nmsg = TraceLocalization.buildMessage(message, args);
        }
        this.commandProcessor.logMessage(logLevel, i18nmsg);
    }

    public void logDebug(String message, Object[] args) {
        this.logMessage(4, message, args);
    }

    public void logDebugWithoutLevelCheck(String message, Object[] args) {
        this.logMessageWithoutLevelCheck(4, message, args);
    }

    public void logInfo(String message, Object[] args) {
        this.logMessage(3, message, args);
    }

    public void logWarning(String message, Object[] args) {
        this.logMessage(2, message, args);
    }

    public void logWarningWithoutLevelCheck(String message, Object[] args) {
        this.logMessageWithoutLevelCheck(2, message, args);
    }

    public void logError(String message, Object[] args) {
        this.logMessage(1, message, args);
    }

    public ServiceId getServiceId() {
        return this.serviceId;
    }

    @Override
    public String getChannel() {
        return this.getServiceId().getChannel();
    }

    @Override
    public void setChannel(String channel) {
        this.getServiceId().setChannel(channel);
    }

    @Override
    public boolean isCommandProcessorASession() {
        return this.isEclipseLinkSession;
    }

    @Override
    public String getUrl() {
        return this.getServiceId().getURL();
    }

    @Override
    public void setUrl(String url) {
        this.getServiceId().setURL(url);
    }

    @Override
    public boolean shouldPropagateAsynchronously() {
        return this.isAsynchronous;
    }

    @Override
    public void setShouldPropagateAsynchronously(boolean asyncMode) {
        this.isAsynchronous = asyncMode;
    }

    public void replaceLocalHostIPAddress(String ipAddress) {
        String newURL = Helper.replaceFirstSubString(this.getUrl(), "$HOST", ipAddress);
        if (newURL != null) {
            this.setUrl(newURL);
        }
    }

    public void replaceTransportPortNumber(String portNumber) {
        String newURL = Helper.replaceFirstSubString(this.getUrl(), "$PORT", portNumber);
        if (newURL != null) {
            this.setUrl(newURL);
        }
    }

    public ServerPlatform getServerPlatform() {
        if (this.isCommandProcessorASession()) {
            return ((DatabaseSessionImpl)this.getCommandProcessor()).getServerPlatform();
        }
        if (this.serverPlatform != null) {
            return this.serverPlatform;
        }
        throw RemoteCommandManagerException.errorGettingServerPlatform();
    }

    public void setServerPlatform(ServerPlatform theServerPlatform) {
        this.serverPlatform = theServerPlatform;
    }
}

