/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.spi.store;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.ehcache.core.config.ExpiryUtils;
import org.ehcache.core.spi.store.Store;

public abstract class AbstractValueHolder<V>
implements Store.ValueHolder<V> {
    private final long id;
    private final long creationTime;
    private volatile long lastAccessTime;
    private volatile long expirationTime;
    private static final AtomicLongFieldUpdater<AbstractValueHolder> ACCESSTIME_UPDATER = AtomicLongFieldUpdater.newUpdater(AbstractValueHolder.class, "lastAccessTime");
    private static final AtomicLongFieldUpdater<AbstractValueHolder> EXPIRATIONTIME_UPDATER = AtomicLongFieldUpdater.newUpdater(AbstractValueHolder.class, "expirationTime");

    protected AbstractValueHolder(long id, long creationTime) {
        this(id, creationTime, -1L);
    }

    protected AbstractValueHolder(long id, long creationTime, long expirationTime) {
        this.id = id;
        this.creationTime = creationTime;
        this.expirationTime = expirationTime;
        this.lastAccessTime = creationTime;
    }

    protected abstract TimeUnit nativeTimeUnit();

    @Override
    public long creationTime(TimeUnit unit) {
        return unit.convert(this.creationTime, this.nativeTimeUnit());
    }

    public void setExpirationTime(long expirationTime, TimeUnit unit) {
        if (expirationTime == -1L) {
            this.updateExpirationTime(-1L);
        } else {
            if (expirationTime <= 0L) {
                throw new IllegalArgumentException("invalid expiration time: " + expirationTime);
            }
            this.updateExpirationTime(this.nativeTimeUnit().convert(expirationTime, unit));
        }
    }

    private void updateExpirationTime(long update) {
        long current;
        while ((current = this.expirationTime) < update && !EXPIRATIONTIME_UPDATER.compareAndSet(this, current, update)) {
        }
    }

    public void accessed(long now, Duration expiration) {
        TimeUnit timeUnit = this.nativeTimeUnit();
        if (expiration != null) {
            if (ExpiryUtils.isExpiryDurationInfinite(expiration)) {
                this.setExpirationTime(-1L, null);
            } else {
                long newExpirationTime = ExpiryUtils.getExpirationMillis(now, expiration);
                this.setExpirationTime(newExpirationTime, timeUnit);
            }
        }
        this.setLastAccessTime(now, timeUnit);
    }

    @Override
    public long expirationTime(TimeUnit unit) {
        long expire = this.expirationTime;
        if (expire == -1L) {
            return -1L;
        }
        return unit.convert(expire, this.nativeTimeUnit());
    }

    @Override
    public boolean isExpired(long expirationTime, TimeUnit unit) {
        long expire = this.expirationTime;
        if (expire == -1L) {
            return false;
        }
        return expire <= this.nativeTimeUnit().convert(expirationTime, unit);
    }

    @Override
    public long lastAccessTime(TimeUnit unit) {
        return unit.convert(this.lastAccessTime, this.nativeTimeUnit());
    }

    public void setLastAccessTime(long lastAccessTime, TimeUnit unit) {
        long current;
        long update = unit.convert(lastAccessTime, this.nativeTimeUnit());
        while ((current = this.lastAccessTime) < update && !ACCESSTIME_UPDATER.compareAndSet(this, current, update)) {
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.creationTime ^ this.creationTime >>> 32);
        result = 31 * result + (int)(this.lastAccessTime ^ this.lastAccessTime >>> 32);
        result = 31 * result + (int)(this.expirationTime ^ this.expirationTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractValueHolder) {
            AbstractValueHolder other = (AbstractValueHolder)obj;
            return other.creationTime(this.nativeTimeUnit()) == this.creationTime && this.creationTime(other.nativeTimeUnit()) == other.creationTime && other.expirationTime(this.nativeTimeUnit()) == this.expirationTime && this.expirationTime(other.nativeTimeUnit()) == other.expirationTime && other.lastAccessTime(this.nativeTimeUnit()) == this.lastAccessTime && this.lastAccessTime(other.nativeTimeUnit()) == other.lastAccessTime;
        }
        return false;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public String toString() {
        return String.format("%s", this.get());
    }
}

