/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.attributes;

import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.attributes.IndexedAttributeAccessor;
import org.glassfish.grizzly.attributes.NullaryFunction;

public class Attribute<T> {
    private AttributeBuilder builder;
    private String name;
    private NullaryFunction<T> initializer;
    private T defaultValue;
    private int attributeIndex;

    public String toString() {
        return "Attribute[" + this.name + ":" + this.attributeIndex + "]";
    }

    protected Attribute(AttributeBuilder builder, String name, T defaultValue) {
        this.builder = builder;
        this.name = name;
        this.initializer = null;
        this.defaultValue = defaultValue;
    }

    protected Attribute(AttributeBuilder builder, String name, NullaryFunction<T> initializer) {
        this.builder = builder;
        this.name = name;
        this.initializer = initializer;
        this.defaultValue = null;
    }

    public T get(AttributeHolder attributeHolder) {
        T result = this.weakGet(attributeHolder);
        if (result == null && (result = this.initializer != null ? this.initializer.evaluate() : this.defaultValue) != null) {
            this.set(attributeHolder, result);
        }
        return result;
    }

    public T get(AttributeStorage storage) {
        AttributeHolder holder = storage.getAttributes();
        if (holder != null) {
            return this.get(holder);
        }
        T result = this.initializer != null ? this.initializer.evaluate() : this.defaultValue;
        if (result != null) {
            this.set(storage, result);
        }
        return result;
    }

    public void set(AttributeHolder attributeHolder, T value) {
        IndexedAttributeAccessor indexedAccessor = attributeHolder.getIndexedAttributeAccessor();
        if (indexedAccessor != null) {
            indexedAccessor.setAttribute(this.attributeIndex, value);
        } else {
            attributeHolder.setAttribute(this.name, value);
        }
    }

    public void set(AttributeStorage storage, T value) {
        this.set(storage.obtainAttributes(), value);
    }

    public T remove(AttributeHolder attributeHolder) {
        T result = this.weakGet(attributeHolder);
        if (result != null) {
            this.set(attributeHolder, null);
        }
        return result;
    }

    public T remove(AttributeStorage storage) {
        AttributeHolder holder = storage.getAttributes();
        if (holder != null) {
            this.remove(holder);
        }
        return null;
    }

    public boolean isSet(AttributeHolder attributeHolder) {
        return this.weakGet(attributeHolder) != null;
    }

    public boolean isSet(AttributeStorage storage) {
        AttributeHolder holder = storage.getAttributes();
        if (holder != null) {
            return this.isSet(holder);
        }
        return false;
    }

    public String name() {
        return this.name;
    }

    public int index() {
        return this.attributeIndex;
    }

    protected void setIndex(int index) {
        this.attributeIndex = index;
    }

    private T weakGet(AttributeHolder attributeHolder) {
        Object result = null;
        IndexedAttributeAccessor indexedAccessor = attributeHolder.getIndexedAttributeAccessor();
        result = indexedAccessor != null ? indexedAccessor.getAttribute(this.attributeIndex) : attributeHolder.getAttribute(this.name);
        return (T)result;
    }
}

