/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.filterchain;

import java.util.List;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.TransformationException;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.Transformer;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.CodecFilter;
import org.glassfish.grizzly.filterchain.DefaultFilterChain;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainContext;

public class DefaultDecoderTransformer
implements Transformer {
    private final DefaultFilterChain filterChain;
    private final Attribute<FilterChainContext> contextAttribute;
    private final Attribute inputAttribute;
    private final Attribute outputAttribute;
    private final Attribute<TransformationResult> lastResultAttribute;

    protected DefaultDecoderTransformer(DefaultFilterChain filterChain) {
        this(filterChain, Grizzly.DEFAULT_ATTRIBUTE_BUILDER);
    }

    protected DefaultDecoderTransformer(DefaultFilterChain filterChain, AttributeBuilder attributeBuilder) {
        this.filterChain = filterChain;
        this.contextAttribute = attributeBuilder.createAttribute("ddt_context");
        this.inputAttribute = attributeBuilder.createAttribute("ddt_input");
        this.outputAttribute = attributeBuilder.createAttribute("ddt_output");
        this.lastResultAttribute = attributeBuilder.createAttribute("ddt_last_result");
    }

    public DefaultFilterChain getFilterChain() {
        return this.filterChain;
    }

    public FilterChainContext getContext(AttributeStorage state) {
        return this.contextAttribute.get(state);
    }

    public void setContext(AttributeStorage state, FilterChainContext context) {
        this.contextAttribute.set(state, context);
    }

    public TransformationResult transform(AttributeStorage state) throws TransformationException {
        return this.transform(state, this.getInput(state), this.getOutput(state));
    }

    public TransformationResult transform(AttributeStorage state, Object originalMessage, Object targetMessage) throws TransformationException {
        if (originalMessage == null) {
            originalMessage = this.getInput(state);
        }
        List<Filter> filters = this.getFilters(state);
        TransformationResult<Object> decodeResult = new TransformationResult<Object>(TransformationResult.Status.COMPLETED, originalMessage);
        Object currentMessage = null;
        currentMessage = originalMessage;
        for (Filter filter : filters) {
            CodecFilter codecFilter;
            Transformer<Object, Object> decoder;
            if (!(filter instanceof CodecFilter) || (decoder = (codecFilter = (CodecFilter)filter).getDecoder()) == null) continue;
            decodeResult = decoder.transform(state, currentMessage, null);
            if (decodeResult.getStatus() != TransformationResult.Status.COMPLETED) break;
            currentMessage = decodeResult.getMessage();
        }
        this.setLastResult(state, decodeResult);
        return decodeResult;
    }

    public Object getInput(AttributeStorage state) {
        return this.inputAttribute.get(state);
    }

    public void setInput(AttributeStorage state, Object input) {
        this.inputAttribute.set(state, input);
    }

    public Object getOutput(AttributeStorage state) {
        return this.outputAttribute.get(state);
    }

    public void setOutput(AttributeStorage state, Object outputTarget) {
        this.outputAttribute.set(state, outputTarget);
    }

    public TransformationResult getLastResult(AttributeStorage state) {
        return this.lastResultAttribute.get(state);
    }

    private void setLastResult(AttributeStorage state, TransformationResult lastResult) {
        this.lastResultAttribute.set(state, lastResult);
    }

    @Override
    public AttributeHolder getProperties(AttributeStorage state) {
        return state.getAttributes();
    }

    @Override
    public void hibernate(AttributeStorage state) {
    }

    @Override
    public void release(AttributeStorage state) {
        this.releaseFilterTransformers(state);
        this.contextAttribute.remove(state);
        this.lastResultAttribute.remove(state);
        this.inputAttribute.remove(state);
        this.outputAttribute.remove(state);
    }

    private void releaseFilterTransformers(AttributeStorage state) {
        List<Filter> filters = this.getFilters(state);
        for (Filter filter : filters) {
            Transformer decoder;
            if (!(filter instanceof CodecFilter) || (decoder = ((CodecFilter)filter).getDecoder()) == null) continue;
            decoder.release(state);
        }
    }

    private List<Filter> getFilters(AttributeStorage state) {
        FilterChainContext context = this.getContext(state);
        if (context != null) {
            return context.getExecutedFilters();
        }
        return this.filterChain;
    }
}

