/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.launcher.web.servlet;

import javax.servlet.Servlet;
import org.glassfish.grizzly.web.WebFilter;
import org.glassfish.grizzly.web.WebFilterConfig;
import org.glassfish.grizzly.web.arp.AsyncWebFilter;
import org.glassfish.grizzly.web.arp.AsyncWebFilterConfig;
import org.glassfish.grizzly.web.arp.DefaultAsyncHandler;
import org.glassfish.grizzly.web.container.Adapter;
import org.glassfish.grizzly.web.container.util.ClassLoaderUtil;
import org.glassfish.grizzly.web.servlet.ServletAdapter;
import org.glassfish.grizzly.web.standalone.StandaloneMainUtil;
import org.glassfish.grizzly.web.standalone.StaticHandler;

public class ServletLauncher
extends StandaloneMainUtil {
    private String servletClassName;
    private static final String ENABLE_ASYNC = "com.sun.grizzly.enableARP";
    static int port = 8080;
    static String folder = ".";

    public static void main(String[] args) throws Exception {
        ServletLauncher main = new ServletLauncher();
        main.start(args);
    }

    public WebFilter createWebFilter(String[] args) throws Exception {
        if (args.length == 0) {
            this.printHelpAndExit();
        }
        this.parseOptions(args);
        String appliPath = this.parseApplicationLocation(args);
        appliPath = this.appendWarContentToClassPath(appliPath);
        AsyncWebFilterConfig webConfig = new AsyncWebFilterConfig();
        webConfig.setAdapter(this.configureAdapter(webConfig));
        webConfig.setDisplayConfiguration(true);
        webConfig.setWebAppRootPath(appliPath);
        AsyncWebFilter webFilter = new AsyncWebFilter("MyHtttpServer", webConfig);
        webConfig.setInterceptor(new StaticHandler(webFilter));
        boolean enableAsync = Boolean.valueOf(System.getProperty(ENABLE_ASYNC));
        webConfig.setAsyncEnabled(enableAsync);
        if (enableAsync) {
            webConfig.setAsyncHandler(new DefaultAsyncHandler());
        }
        return webFilter;
    }

    public void printHelpAndExit() {
        System.err.println("Usage: " + ServletLauncher.class.getCanonicalName() + " [options]");
        System.err.println();
        System.err.println("    -p, --port=port                  Server file on the specified port.");
        System.err.println("                                     Default: 8080");
        System.err.println("    -a, --apps=application path      The static resourde folder or jar or war location.");
        System.err.println("                                     Default: .");
        System.err.println("    -h, --help                       Show this help message.");
        System.exit(1);
    }

    public boolean parseOptions(String[] args) {
        if (args.length == 0) {
            this.printHelpAndExit();
            return false;
        }
        for (int i = 0; i < args.length - 1; ++i) {
            String arg = args[i];
            if ("-h".equals(arg) || "--help".equals(arg)) {
                this.printHelpAndExit();
                continue;
            }
            if ("-a".equals(arg)) {
                folder = args[++i];
                continue;
            }
            if (arg.startsWith("--application=")) {
                folder = arg.substring("--application=".length(), arg.length());
                continue;
            }
            if ("-p".equals(arg)) {
                this.setPort(args[++i]);
                continue;
            }
            if (!arg.startsWith("--port=")) continue;
            String num = arg.substring("--port=".length(), arg.length());
            this.setPort(num);
        }
        if (folder == null) {
            System.err.println("Illegal War|Jar file or folder location.");
            this.printHelpAndExit();
        }
        this.servletClassName = args[args.length - 1];
        if (this.servletClassName == null) {
            System.err.println("Illegal Servlet name.");
            this.printHelpAndExit();
        }
        return true;
    }

    public Adapter configureAdapter(WebFilterConfig wf) {
        ServletAdapter adapter = new ServletAdapter();
        adapter.setRootFolder(wf.getWebAppRootPath());
        adapter.setHandleStaticResources(true);
        Servlet servlet = (Servlet)ClassLoaderUtil.load(this.servletClassName);
        if (servlet == null) {
            throw new IllegalStateException("Invalid Servlet ClassName");
        }
        System.out.println("Launching Servlet: " + servlet.getClass().getName());
        adapter.setServletInstance(servlet);
        return adapter;
    }

    public String parseApplicationLocation(String[] args) {
        return folder;
    }
}

