/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memory;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.memory.WrapperAware;

public class MemoryUtils {
    public static <E extends Buffer> E wrap(MemoryManager<E> memoryManager, String s) {
        return MemoryUtils.wrap(memoryManager, s, Charset.defaultCharset());
    }

    public static <E extends Buffer> E wrap(MemoryManager<E> memoryManager, String s, Charset charset) {
        try {
            byte[] byteRepresentation = s.getBytes(charset.name());
            return MemoryUtils.wrap(memoryManager, byteRepresentation);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <E extends Buffer> E wrap(MemoryManager<E> memoryManager, byte[] array) {
        return MemoryUtils.wrap(memoryManager, array, 0, array.length);
    }

    public static <E extends Buffer> E wrap(MemoryManager<E> memoryManager, byte[] array, int offset, int length) {
        if (memoryManager instanceof WrapperAware) {
            return ((WrapperAware)((Object)memoryManager)).wrap(array, offset, length);
        }
        E buffer = memoryManager.allocate(length);
        buffer.put(array, offset, length);
        buffer.flip();
        return buffer;
    }

    public static <E extends Buffer> E wrap(MemoryManager<E> memoryManager, ByteBuffer byteBuffer) {
        if (memoryManager instanceof WrapperAware) {
            return ((WrapperAware)((Object)memoryManager)).wrap(byteBuffer);
        }
        if (byteBuffer.hasArray()) {
            return MemoryUtils.wrap(memoryManager, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        }
        throw new IllegalStateException("Can not wrap ByteBuffer");
    }
}

