/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memory.slab;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.glassfish.grizzly.memory.slab.Slab;
import org.glassfish.grizzly.memory.slab.SlabMemoryManagerFactory;

public final class SlabPoolImpl
implements SlabMemoryManagerFactory.SlabPool {
    private final int _maxAllocationSize;
    private final long _minSize;
    private final long _maxSize;
    private final boolean _bufferType;
    private boolean _closed = false;
    private Set<Slab> _emptySlabs;
    private Set<Slab> _fullSlabs;
    private Set<Slab> _partialSlabs;

    public SlabPoolImpl(int maxAllocationSize, long minSize, long maxSize, boolean bufferType) {
        this._maxAllocationSize = maxAllocationSize;
        this._minSize = minSize;
        this._maxSize = maxSize;
        this._bufferType = bufferType;
        this._emptySlabs = new HashSet<Slab>();
        this._fullSlabs = new HashSet<Slab>();
        this._partialSlabs = new HashSet<Slab>();
        while (this.freeSpace() < minSize) {
            Slab slab = new Slab(maxAllocationSize, bufferType);
            this._emptySlabs.add(slab);
        }
    }

    private void checkClosed() {
        if (this._closed) {
            throw new IllegalStateException("SlabPoolImpl is closed");
        }
    }

    @Override
    public synchronized void close() {
        this.checkClosed();
        this._emptySlabs = null;
        this._fullSlabs = null;
        this._partialSlabs = null;
        this._closed = true;
    }

    @Override
    public synchronized int maxAllocationSize() {
        this.checkClosed();
        return this._maxAllocationSize;
    }

    @Override
    public synchronized long minSize() {
        this.checkClosed();
        return this._minSize;
    }

    @Override
    public synchronized long maxSize() {
        this.checkClosed();
        return this._maxSize;
    }

    @Override
    public synchronized int numFreeSlabs() {
        this.checkClosed();
        return this._emptySlabs.size();
    }

    @Override
    public synchronized int numPartialSlabs() {
        this.checkClosed();
        return this._partialSlabs.size();
    }

    @Override
    public synchronized int numFullSlabs() {
        this.checkClosed();
        return this._fullSlabs.size();
    }

    private long totalSpaceInUse() {
        long result = this._maxAllocationSize;
        return result *= (long)(this._emptySlabs.size() + this._partialSlabs.size() + this._fullSlabs.size());
    }

    private long computeAvailableSize(Set<Slab> set) {
        long result = 0L;
        for (Slab slab : set) {
            result += (long)slab.sizeAvailable();
        }
        return result;
    }

    private long computeAllocatedSize(Set<Slab> set) {
        long result = 0L;
        for (Slab slab : set) {
            result += (long)slab.sizeAllocated();
        }
        return result;
    }

    private long computeDisposedSize(Set<Slab> set) {
        long result = 0L;
        for (Slab slab : set) {
            result += (long)slab.sizeDisposed();
        }
        return result;
    }

    @Override
    public synchronized long freeSpace() {
        this.checkClosed();
        return this.computeAvailableSize(this._emptySlabs) + this.computeAvailableSize(this._partialSlabs);
    }

    @Override
    public synchronized long unavailableSpace() {
        this.checkClosed();
        return this.computeDisposedSize(this._partialSlabs) + this.computeDisposedSize(this._fullSlabs);
    }

    @Override
    public synchronized long allocatedSpace() {
        this.checkClosed();
        return this.computeAllocatedSize(this._partialSlabs) + this.computeAllocatedSize(this._fullSlabs);
    }

    @Override
    public synchronized boolean bufferType() {
        this.checkClosed();
        return this._bufferType;
    }

    public synchronized Slab getSlab() {
        this.checkClosed();
        Slab result = null;
        Iterator<Slab> i$ = this._emptySlabs.iterator();
        if (i$.hasNext()) {
            Slab slab;
            result = slab = i$.next();
        }
        if (result == null) {
            result = new Slab(this._maxAllocationSize, this._bufferType);
        } else {
            this._emptySlabs.remove(result);
        }
        this._partialSlabs.add(result);
        return result;
    }

    public synchronized void releaseSlab(Slab slab) {
        this.checkClosed();
        slab.markFull();
        this._partialSlabs.remove(slab);
        this._fullSlabs.add(slab);
    }

    public synchronized void dispose(Slab slab, ByteBuffer buffer) {
        this.checkClosed();
        slab.dispose(buffer);
        if (slab.getState() == Slab.State.EMPTY) {
            this._fullSlabs.remove(slab);
            slab.markEmpty();
            if (this.totalSpaceInUse() < this._maxSize) {
                this._emptySlabs.add(slab);
            }
        }
    }
}

