/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.AbstractReader;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.Interceptor;
import org.glassfish.grizzly.ProcessorResult;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.asyncqueue.AsyncQueue;
import org.glassfish.grizzly.asyncqueue.AsyncQueueReader;
import org.glassfish.grizzly.asyncqueue.AsyncReadQueueRecord;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.nio.AbstractNIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.util.LinkedTransferQueue;
import org.glassfish.grizzly.util.ObjectPool;

public abstract class AbstractNIOAsyncQueueReader
extends AbstractReader<SocketAddress>
implements AsyncQueueReader<SocketAddress> {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    protected int defaultBufferSize = 8192;
    protected NIOTransport transport;
    private Logger logger = Grizzly.logger;

    public AbstractNIOAsyncQueueReader(NIOTransport transport) {
        this.transport = transport;
    }

    @Override
    public Future<ReadResult<Buffer, SocketAddress>> read(Connection connection, Buffer buffer, CompletionHandler<ReadResult<Buffer, SocketAddress>> completionHandler, Interceptor<ReadResult> interceptor) throws IOException {
        int finalInterceptorEvent;
        if (connection == null) {
            throw new IOException("Connection is null");
        }
        if (!connection.isOpen()) {
            throw new IOException("Connection is closed");
        }
        FutureImpl<ReadResult<Buffer, SocketAddress>> future = new FutureImpl<ReadResult<Buffer, SocketAddress>>();
        ReadResult currentResult = new ReadResult(connection);
        currentResult.setMessage(null);
        currentResult.setReadSize(0);
        AsyncQueue<AsyncReadQueueRecord> connectionQueue = ((AbstractNIOConnection)connection).getAsyncReadQueue();
        LinkedTransferQueue<AsyncReadQueueRecord> queue = connectionQueue.getQueue();
        AtomicReference<AsyncReadQueueRecord> currentElement = connectionQueue.getCurrentElement();
        ReentrantLock lock = connectionQueue.getQueuedActionLock();
        boolean isLockedByMe = false;
        AsyncReadQueueRecord queueRecord = new AsyncReadQueueRecord();
        queueRecord.set(buffer, future, currentResult, completionHandler, interceptor);
        try {
            boolean registerForReadingInstr;
            if (currentElement.get() == null && lock.tryLock()) {
                isLockedByMe = true;
                if (currentElement.compareAndSet(null, queueRecord)) {
                    this.doRead(connection, currentResult, buffer);
                } else {
                    isLockedByMe = false;
                    lock.unlock();
                }
            }
            int interceptInstructions = this.intercept(connection, 1, queueRecord, currentResult);
            boolean bl = registerForReadingInstr = interceptor == null || (interceptInstructions & 0x40) == 0;
            if ((interceptInstructions & 1) != 0 || interceptor == null && this.isFinished(currentResult)) {
                if (isLockedByMe) {
                    AsyncReadQueueRecord nextRecord = queue.poll();
                    if (nextRecord != null) {
                        currentElement.set(nextRecord);
                        lock.unlock();
                        isLockedByMe = false;
                        if (registerForReadingInstr) {
                            this.onReadyToRead(connection);
                        }
                    } else {
                        currentElement.set(null);
                        lock.unlock();
                        isLockedByMe = false;
                        if (registerForReadingInstr && queue.peek() != null) {
                            this.onReadyToRead(connection);
                        }
                    }
                }
                this.onReadCompleted(connection, queueRecord);
                finalInterceptorEvent = 2;
            } else {
                if ((interceptInstructions & 4) != 0) {
                    queueRecord.setCurrentResult(new ReadResult(connection));
                    queueRecord.setBuffer(null);
                }
                boolean isRegisterForReading = false;
                if (currentElement.get() != queueRecord) {
                    queue.offer(queueRecord);
                    if (!lock.isLocked()) {
                        isRegisterForReading = true;
                    }
                } else {
                    this.onReadIncompleted(connection, queueRecord);
                    isRegisterForReading = true;
                    if (isLockedByMe) {
                        isLockedByMe = false;
                        lock.unlock();
                    }
                }
                if (registerForReadingInstr && isRegisterForReading) {
                    this.onReadyToRead(connection);
                }
                finalInterceptorEvent = 3;
            }
        }
        catch (IOException e) {
            this.onReadFailure(connection, queueRecord, e);
            throw e;
        }
        finally {
            if (isLockedByMe) {
                lock.unlock();
            }
        }
        this.intercept(connection, finalInterceptorEvent, queueRecord, null);
        return future;
    }

    @Override
    public boolean isReady(Connection connection) {
        AsyncQueue<AsyncReadQueueRecord> connectionQueue = ((AbstractNIOConnection)connection).getAsyncReadQueue();
        return connectionQueue != null && (connectionQueue.getCurrentElement().get() != null || connectionQueue.getQueue() != null && !connectionQueue.getQueue().isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processAsync(Connection connection) throws IOException {
        AsyncQueue<AsyncReadQueueRecord> connectionQueue = ((AbstractNIOConnection)connection).getAsyncReadQueue();
        LinkedTransferQueue<AsyncReadQueueRecord> queue = connectionQueue.getQueue();
        AtomicReference<AsyncReadQueueRecord> currentElement = connectionQueue.getCurrentElement();
        ReentrantLock lock = connectionQueue.getQueuedActionLock();
        boolean isLockedByMe = false;
        if (currentElement.get() == null) {
            AsyncReadQueueRecord nextRecord = queue.peek();
            if (nextRecord == null || !lock.tryLock()) return;
            if (!queue.isEmpty() && currentElement.compareAndSet(null, nextRecord)) {
                queue.remove();
            }
        } else if (!lock.tryLock()) {
            return;
        }
        isLockedByMe = true;
        int finalInterceptorEvent = 2;
        AsyncReadQueueRecord queueRecord = null;
        try {
            while (currentElement.get() != null) {
                boolean registerForReadingInstr;
                queueRecord = currentElement.get();
                ReadResult currentResult = (ReadResult)queueRecord.getCurrentResult();
                Buffer message = queueRecord.getBuffer();
                this.doRead(connection, currentResult, message);
                Interceptor interceptor = queueRecord.getInterceptor();
                int interceptInstructions = this.intercept(connection, 1, queueRecord, currentResult);
                boolean bl = registerForReadingInstr = interceptor == null || (interceptInstructions & 0x40) == 0;
                if ((interceptInstructions & 1) != 0 || interceptor == null && this.isFinished(currentResult)) {
                    AsyncReadQueueRecord nextRecord;
                    currentElement.set(queue.poll());
                    this.onReadCompleted(connection, queueRecord);
                    this.intercept(connection, 2, queueRecord, null);
                    if (currentElement.get() != null) continue;
                    if (isLockedByMe) {
                        isLockedByMe = false;
                        lock.unlock();
                    }
                    if ((nextRecord = queue.peek()) != null && lock.tryLock()) {
                        isLockedByMe = true;
                        if (queue.isEmpty() || !currentElement.compareAndSet(null, nextRecord)) continue;
                        queue.remove();
                        continue;
                    }
                } else {
                    if ((interceptInstructions & 4) != 0) {
                        queueRecord.setCurrentResult(new ReadResult(connection));
                        queueRecord.setBuffer(null);
                    }
                    this.onReadIncompleted(connection, queueRecord);
                    if (isLockedByMe) {
                        isLockedByMe = false;
                        lock.unlock();
                    }
                    if (registerForReadingInstr) {
                        this.onReadyToRead(connection);
                    }
                    finalInterceptorEvent = 3;
                }
                break;
            }
        }
        catch (IOException e) {
            this.onReadFailure(connection, queueRecord, e);
        }
        catch (Exception e) {
            String message = "Unexpected exception occurred in AsyncQueueReader";
            this.logger.log(Level.SEVERE, message, e);
            IOException ioe = new IOException(e.getClass() + ": " + message);
            this.onReadFailure(connection, queueRecord, ioe);
        }
        finally {
            if (isLockedByMe) {
                connectionQueue.getQueuedActionLock().unlock();
            }
        }
        if (finalInterceptorEvent != 3) return;
        this.intercept(connection, finalInterceptorEvent, queueRecord, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClose(Connection connection) {
        AbstractNIOConnection nioConnection = (AbstractNIOConnection)connection;
        AsyncQueue<AsyncReadQueueRecord> readQueue = nioConnection.getAsyncReadQueue();
        if (readQueue != null) {
            readQueue.getQueuedActionLock().lock();
            try {
                AsyncReadQueueRecord record = readQueue.getCurrentElement().getAndSet(null);
                this.failReadRecord(connection, record, new IOException("Connection closed"));
                LinkedTransferQueue<AsyncReadQueueRecord> recordsQueue = readQueue.getQueue();
                if (recordsQueue != null) {
                    while (!recordsQueue.isEmpty()) {
                        this.failReadRecord(connection, recordsQueue.poll(), new IOException("Connection closed"));
                    }
                }
            }
            finally {
                readQueue.getQueuedActionLock().unlock();
            }
        }
    }

    public ObjectPool getContextPool() {
        return null;
    }

    @Override
    public boolean isInterested(IOEvent ioEvent) {
        return ioEvent == IOEvent.READ;
    }

    public ProcessorResult process(Context context) throws IOException {
        this.processAsync(context.getConnection());
        return null;
    }

    @Override
    public void setInterested(IOEvent ioEvent, boolean isInterested) {
    }

    @Override
    public void close() {
    }

    protected int doRead(Connection connection, ReadResult currentResult, Buffer message) throws IOException {
        Buffer buffer = message;
        int readBytes = this.read0(connection, buffer, currentResult);
        if (readBytes == -1) {
            throw new EOFException();
        }
        return readBytes;
    }

    protected void onReadCompleted(Connection connection, AsyncReadQueueRecord record) throws IOException {
        FutureImpl future = (FutureImpl)record.getFuture();
        ReadResult currentResult = (ReadResult)record.getCurrentResult();
        future.setResult(currentResult);
        CompletionHandler completionHandler = record.getCompletionHandler();
        if (completionHandler != null) {
            completionHandler.completed(connection, currentResult);
        }
    }

    protected void onReadIncompleted(Connection connection, AsyncReadQueueRecord record) throws IOException {
        ReadResult currentResult = (ReadResult)record.getCurrentResult();
        CompletionHandler completionHandler = record.getCompletionHandler();
        if (completionHandler != null) {
            completionHandler.updated(connection, currentResult);
        }
    }

    protected void onReadFailure(Connection connection, AsyncReadQueueRecord failedRecord, IOException e) {
        this.failReadRecord(connection, failedRecord, e);
        try {
            connection.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    protected void failReadRecord(Connection connection, AsyncReadQueueRecord record, IOException e) {
        if (record == null) {
            return;
        }
        FutureImpl future = (FutureImpl)record.getFuture();
        if (!future.isDone()) {
            CompletionHandler completionHandler = record.getCompletionHandler();
            if (completionHandler != null) {
                completionHandler.failed(connection, e);
            }
            future.failure(e);
        }
    }

    private int intercept(Connection connection, int event, AsyncReadQueueRecord asyncQueueRecord, ReadResult currentResult) {
        Interceptor<ReadResult> interceptor = asyncQueueRecord.getInterceptor();
        if (interceptor != null) {
            return interceptor.intercept(event, asyncQueueRecord, currentResult);
        }
        return 0;
    }

    private <E> boolean isFinished(ReadResult<E, ?> readResult) {
        E message = readResult.getMessage();
        return readResult.getReadSize() > 0 || !((Buffer)message).hasRemaining();
    }

    protected abstract int read0(Connection var1, Buffer var2, ReadResult<Buffer, SocketAddress> var3) throws IOException;

    protected abstract void onReadyToRead(Connection var1) throws IOException;
}

